/*
 * Decompiled with CFR 0.152.
 */
package de.psdev.stabbedandroid;

import android.content.Context;
import dagger.ObjectGraph;
import de.psdev.stabbedandroid.StabbedContext;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtendedGraphHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ExtendedGraphHelper.class);
    @Nullable
    private ObjectGraph mExtendedGraph;

    void onCreate(Context context, List<Object> modules, Object target) {
        StabbedContext application = (StabbedContext)context.getApplicationContext();
        this.mExtendedGraph = application.getObjectGraph().plus(modules.toArray());
        this.mExtendedGraph.inject(target);
    }

    void onDestroy() {
        this.mExtendedGraph = null;
    }

    void inject(Object object) {
        if (this.mExtendedGraph != null) {
            this.mExtendedGraph.inject(object);
        } else {
            LOG.warn("Used inject outside of activity lifecycle, or call to onCreate missing.");
        }
    }

    @Nullable
    public ObjectGraph getExtendedGraph() {
        return this.mExtendedGraph;
    }
}

