package de.pco.example;

/*-
 * #%L
 * pco-example
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

import javax.swing.table.AbstractTableModel;

import de.pco.sdk.BildStruct;
import de.pco.sdk.enums.BildField;

/**
 * Represents the data layer of the table
 * @author PCO
 *
 */
public class MetadataTableModel extends AbstractTableModel 
{
    private BildStruct metadata;
    private boolean loaded;
    
    public MetadataTableModel() {
        this.loaded = false;
    }
    
    /**
     * Returns if the cell is editable
     */
    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) 
    {
        if (    loaded == false 
            ||  rowIndex == BildField.X_RES.ordinal() 
            ||  rowIndex == BildField.Y_RES.ordinal()) 
        {
            return false;
        }
        if (columnIndex == 1) { 
            return true;
        }
        return false;
    }
    
    /**
     * Returns the cell value at particular coordinates
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) 
    {
        if (columnIndex == 0) {
            return BildField.values()[rowIndex].toString();
        }
        
        if (metadata == null) {
            return ""; 
        }
        else {
            BildField field = BildField.values()[rowIndex];
            return BildField.getValueOfField(metadata, field);
        } 
    }
    
    /**
     * Returns the count of the table row
     */
    @Override
    public int getRowCount() {
        return BildField.values().length;
    }
    
    /**
     * Returns the count of the columns
     */
    @Override
    public int getColumnCount() {
        return 2;
    }
    
    /**
     * Sets the backing MetadataBean object
     * @param metadata
     */
    public void setMetadataBean(BildStruct metadata) {
        this.metadata = metadata;
    }
    
    /**
     * Sets that the table was loaded
     * @param loaded
     */
    public void setLoaded(boolean loaded)
    {
        this.loaded = loaded;
    }
    
    /**
     * Sets the value in the given cell
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) 
    {
        if (metadata == null) {
            return; 
        }
        
        BildField field = BildField.values()[rowIndex];
        BildField.setValueOfField(metadata, field, aValue);
    }
    
    /**
     * Returns the name of the color
     */
    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Field";
        }
        else if (column == 1) {
            return "Value";
        }
        else {
            return super.getColumnName(column);
        }
    }
}
