package de.pco.example;

/*-
 * #%L
 * pco-example
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

import javax.swing.JPanel;

/**
 * Drawing panel for the rendered images 
 * @author PCO
 *
 */
public class PaintPanel extends JPanel 
{
    private BufferedImage image = null;
    
    /**
     * Constructor
     */
    PaintPanel() {
        this.setOpaque(true);
    }

    /**
     * Component that does the rendering.
     */
    @Override
    public void paintComponent(Graphics g) 
    {
        if (this.image != null) 
        {            
            Image scaledImage = this.image.getScaledInstance(this.getWidth(), this.getHeight(), 0);
            g.drawImage(scaledImage, 0, 0, null);
        }
    }

    /**
     * Getter
     * @return
     */
    public BufferedImage getImage() {
        return image;
    }

    /**
     * Setter
     * @param image
     */
    public void setImage(BufferedImage image) {
        this.image = image;
    }
}
