/*
 * Decompiled with CFR 0.152.
 */
package de.pco.example;

import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageMetadata;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageReaderSpi;
import de.pco.example.MetadataTableEditor;
import de.pco.example.MetadataTableModel;
import de.pco.example.MetadataTableRenderer;
import de.pco.example.PaintPanel;
import de.pco.imageio.B16ImageReader;
import de.pco.imageio.B16ImageReaderSpi;
import de.pco.imageio.B16ImageWriter;
import de.pco.imageio.PcoIIOMetadata;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SimpleExample
extends JFrame {
    private static StringBuilder sb = null;
    private static final String APPLICATION_TITLE = "PCO.java Example Application";
    private JMenuBar menuMB = null;
    private JMenuItem showMetadataMI = null;
    private PaintPanel paintP = null;
    private PcoIIOMetadata metadata = null;
    private MetadataTableModel metadataTM = null;
    private MetadataTableEditor metadataTE = null;
    private IIOImage imageContainer = null;
    private JMenuItem saveMI = null;
    private JLabel statusL = null;
    private JFileChooser openFC = null;
    private JFileChooser saveFC = null;

    private SimpleExample() {
        final SimpleExample self = this;
        this.setTitle(APPLICATION_TITLE);
        this.setSize(new Dimension(800, 500));
        this.setDefaultCloseOperation(3);
        Dimension minimumSize = new Dimension(500, 50);
        this.paintP = new PaintPanel();
        JScrollPane paintSP = new JScrollPane(this.paintP);
        this.metadataTM = new MetadataTableModel();
        JTable tableT = new JTable(this.metadataTM);
        this.metadataTE = new MetadataTableEditor();
        tableT.setDefaultEditor(Object.class, this.metadataTE);
        tableT.setDefaultRenderer(Object.class, new MetadataTableRenderer());
        JScrollPane metadataSP = new JScrollPane(tableT);
        JSplitPane splitP = new JSplitPane(1, false, paintSP, metadataSP);
        splitP.setDividerLocation(0.9);
        this.add(splitP);
        paintSP.setMinimumSize(minimumSize);
        this.menuMB = new JMenuBar();
        this.openFC = new JFileChooser();
        this.saveFC = new JFileChooser();
        JMenu fileM = new JMenu("File");
        fileM.setMnemonic('F');
        JMenuItem openMI = new JMenuItem("Open...");
        openMI.setMnemonic('O');
        openMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                self.metadataTE.stopCellEditing();
                self.openFC.setFileFilter(new FileNameExtensionFilter("B16 File, TIFF File", "b16", "tif", "tiff"));
                if (self.openFC.getSelectedFile() != null) {
                    self.openFC.setCurrentDirectory(SimpleExample.this.openFC.getSelectedFile().getParentFile());
                }
                if (self.openFC.showOpenDialog(self) == 0) {
                    File file = self.openFC.getSelectedFile();
                    BufferedImage image = null;
                    Object reader = null;
                    boolean isB16 = false;
                    boolean isTiff = false;
                    try {
                        ImageInputStream iis = ImageIO.createImageInputStream(file);
                        B16ImageReaderSpi b16Spi = new B16ImageReaderSpi();
                        TIFFImageReaderSpi tiffSpi = new TIFFImageReaderSpi();
                        if (b16Spi.canDecodeInput((Object)iis)) {
                            isB16 = true;
                            reader = new B16ImageReader();
                        } else if (tiffSpi.canDecodeInput((Object)iis)) {
                            isTiff = true;
                            reader = new TIFFImageReaderSpi().createReaderInstance();
                        } else {
                            JOptionPane.showMessageDialog(self, "File cannot be opened.", "Error", 0);
                            return;
                        }
                        ((ImageReader)reader).setInput(iis);
                        self.imageContainer = ((ImageReader)reader).readAll(0, ((ImageReader)reader).getDefaultReadParam());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    if (self.imageContainer != null) {
                        image = (BufferedImage)self.imageContainer.getRenderedImage();
                        if (isB16) {
                            self.metadata = (PcoIIOMetadata)self.imageContainer.getMetadata();
                        } else {
                            TIFFImageMetadata tim = (TIFFImageMetadata)self.imageContainer.getMetadata();
                            B16ImageWriter writer = new B16ImageWriter();
                            ImageTypeSpecifier imageType = null;
                            try {
                                imageType = ((ImageReader)reader).getImageTypes(0).next();
                                self.metadata = (PcoIIOMetadata)writer.convertImageMetadata((IIOMetadata)tim, imageType, null);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                        double aspectRatio = (double)image.getWidth() / (double)image.getHeight();
                        String newTitle = "PCO.java Example Application - " + file.getName();
                        self.setTitle(newTitle);
                        newTitle = file.getName();
                        if (isTiff) {
                            if (((SimpleExample)self).metadata.getMetadataBean().bitRes == 16 && !((SimpleExample)self).metadata.getMetadataBean().isColor) {
                                newTitle = newTitle + " (16-Bit grayscale), convertible in B16";
                                self.saveMI.setEnabled(true);
                            } else {
                                newTitle = newTitle + " (";
                                newTitle = newTitle + ((SimpleExample)self).metadata.getMetadataBean().bitRes;
                                newTitle = newTitle + "-Bit ";
                                newTitle = ((SimpleExample)self).metadata.getMetadataBean().isColor ? newTitle + "RGB)" : newTitle + "grayscale)";
                                newTitle = newTitle + ", not convertible in B16";
                                self.saveMI.setEnabled(false);
                            }
                        } else {
                            self.saveMI.setEnabled(true);
                        }
                        self.statusL.setText(newTitle);
                        self.setSize(new Dimension((int)(800.0 * aspectRatio), 500));
                        self.getPaintP().setImage(image);
                        self.metadataTM.setMetadataBean(SimpleExample.this.metadata.getMetadataBean());
                        self.metadataTM.setLoaded(true);
                        self.metadataTM.fireTableDataChanged();
                        self.showMetadataMI.setEnabled(true);
                        self.repaint();
                    }
                }
            }
        });
        this.saveMI = new JMenuItem("Save...");
        this.saveMI.setEnabled(false);
        this.saveMI.setMnemonic('S');
        this.saveMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                self.metadataTE.stopCellEditing();
                if (self.saveFC.getSelectedFile() != null) {
                    self.saveFC.setCurrentDirectory(SimpleExample.this.saveFC.getSelectedFile().getParentFile());
                }
                self.saveFC.setFileFilter(new FileNameExtensionFilter("B16 File", "b16"));
                boolean closeSaveDialog = false;
                File file = null;
                while (!closeSaveDialog) {
                    if (self.saveFC.showSaveDialog(self) == 0) {
                        file = self.saveFC.getSelectedFile();
                        if (!file.getName().endsWith("b16") && !file.getName().endsWith("B16")) {
                            file = new File(file.getParentFile(), file.getName() + ".b16");
                        }
                        if (file.exists()) {
                            int result = JOptionPane.showOptionDialog(self, "File exists. Do you want to overwrite it?", "Overwrite", 0, 3, null, null, null);
                            if (result != 0) continue;
                            closeSaveDialog = true;
                            continue;
                        }
                        closeSaveDialog = true;
                        continue;
                    }
                    return;
                }
                try {
                    B16ImageWriter writer = new B16ImageWriter();
                    writer.setOutput((Object)ImageIO.createImageOutputStream(file));
                    writer.write(SimpleExample.this.imageContainer);
                    JOptionPane.showMessageDialog(self, "Image saved");
                    self.openFC.setSelectedFile(file);
                    self.statusL.setText(file.getName());
                    String newTitle = "PCO.java Example Application - " + file.getName();
                    self.setTitle(newTitle);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.showMetadataMI = new JMenuItem("Show metadata");
        this.showMetadataMI.setEnabled(false);
        this.showMetadataMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                self.metadataTE.stopCellEditing();
                JDialog dialog = new JDialog(self, "Metadata in the native XML", true);
                JTextArea metadataTA = new JTextArea();
                SimpleExample.displayMetadata(self.metadata.getAsTree(self.metadata.getNativeMetadataFormatName()));
                JScrollPane metadataSP = new JScrollPane(metadataTA);
                JPanel contentPane = new JPanel(new BorderLayout());
                contentPane.add((Component)metadataSP, "Center");
                contentPane.setOpaque(true);
                dialog.setContentPane(contentPane);
                dialog.setSize(new Dimension(600, 850));
                dialog.setLocationRelativeTo(self);
                metadataTA.setText(sb.toString());
                metadataTA.setCaretPosition(0);
                dialog.setVisible(true);
            }
        });
        JMenuItem exitMI = new JMenuItem("Exit");
        exitMI.setMnemonic('x');
        exitMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                self.dispose();
            }
        });
        fileM.add(openMI);
        fileM.add(this.saveMI);
        fileM.add(new JSeparator());
        fileM.add(exitMI);
        this.menuMB.add(fileM);
        this.setJMenuBar(this.menuMB);
        JPanel statusBar = new JPanel(new BorderLayout());
        statusBar.setBorder(new BevelBorder(1));
        this.statusL = new JLabel(" ");
        statusBar.add((Component)this.statusL, "Before");
        this.add((Component)statusBar, "South");
        this.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleExample example = new SimpleExample();
            }
        });
    }

    private PaintPanel getPaintP() {
        return this.paintP;
    }

    private MetadataTableModel getMetadataTM() {
        return this.metadataTM;
    }

    private static void displayMetadata(Node root) {
        sb = new StringBuilder();
        SimpleExample.displayMetadata(root, 0);
    }

    private static void indent(int level) {
        for (int i = 0; i < level; ++i) {
            sb.append("    ");
        }
    }

    private static void displayMetadata(Node node, int level) {
        Node child;
        SimpleExample.indent(level);
        sb.append("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                sb.append(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
        }
        if ((child = node.getFirstChild()) != null) {
            sb.append(">\n");
            while (child != null) {
                SimpleExample.displayMetadata(child, level + 1);
                child = child.getNextSibling();
            }
            SimpleExample.indent(level);
            sb.append("</" + node.getNodeName() + ">\n");
        } else {
            sb.append("/>\n");
        }
    }
}

