## About

[pco.java](https://www.pco.de/software/third-party-software/java/) project provides a plug-in for the Java ImageIO API to display the images
and get the metadata from the proprietary B16 file format of the PCO cameras.

Provides the ability to retrieve PCO-specific metadata also from the standard TIFF files.  
Depends on the TIFF package of [TwelveMonkeys ImageIO](https://github.com/haraldk/TwelveMonkeys).
 
Project is built using Apache Maven
  
Group-ID: de.pco  
Artifact-ID (Maven modules):  
- pco -- Parent pom.xml  
- pco-common -- Common sources for the other modules
- pco-imageio -- Java ImageIO plugin for reading and writing B16 files    
- pco-example -- Example application
 
All jars are compiled and tested for at least Java 8.

## Download  
Maven artifacts on the Maven Central Repository: [https://repo1.maven.org/maven2/de/pco/](https://repo1.maven.org/maven2/de/pco/)  
Parent pom.xml: [https://search.maven.org/artifact/de.pco/pco/1.0.1/pom](https://search.maven.org/artifact/de.pco/pco/1.0.1/pom)

If only ImageIO plugin for B16 files necessary, add to your pom.xml

    <dependency>
      <groupId>de.pco</groupId>
      <artifactId>pco-imageio</artifactId>
      <version>1.0.1</version>
    </dependency>


Binaries and sources are also available directly from [www.pco.de](https://www.pco.de/software/third-party-software/java/).

## Example

pco-example artifact presents an application where the user can display B16 and 
TIFF files, edit the inherent metadata from the PCO cameras and save the B16 file again.

Source codes of the application are in the package de.pco.example, 
the main class is SimpleExample.java.

Run the example application (by installed Java) with the mere double-click
on pco-example/pco-example-1.0.1-jar-with-dependencies.jar or from the console 
using

    java -jar pco-example-1.0.1-jar-with-dependencies.jar 

## Basic Usage

pco-imageio artifact contains the ImageIO plugin for the B16 files. 

After including pco-common-1.0.1.jar and pco-imageio-1.0.1.jar on the classpath, the plugin 
will be available  

    File file = new File("image.b16");
    BufferedImage image = ImageIO.read(file);

    
## Advanced Usage

To retrieve the PCO metadata from the B16 files

    B16ImageReader reader = new B16ImageReader();
    ImageInputStream iis = ImageIO.createImageInputStream(file);
    reader.setInput(iis);
    BufferedImage image = reader.read(0);
    PcoIIOMetadata metadata = (PcoIIOMetadata)reader.getImageMetadata(0);

To retrieve the PCO metadata from the TIFF files
 
    TIFFImageReader reader = new TIFFImageReader();
    ...
    TIFFImageMetadata tim = (TIFFImageMetadata)reader.getImageMetadata(0);
    B16ImageWriter writer = new B16ImageWriter();
    ImageTypeSpecifier imageType = null;
    PcoIIOMetadata metadata = null;
    imageType = reader.getImageTypes(0).next();
    metadata = (PcoIIOMetadata)writer.convertImageMetadata(tim, imageType, null);
    
## License

Project is distributed under the MIT License

    The MIT License (MIT)
    
    Copyright (c) 2020, PCO
    
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
    
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
    
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
    
----