/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.junitsupport;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Not a test")
public class DelegateClassTestBase {
    private final Class<?> delegateType;
    private final Class<?> classUnderTest;
    private final TestMethod[] testMethods;

    public DelegateClassTestBase(Class<?> delegateType, Class<?> classUnderTest, TestMethod ... testMethods) {
        this.delegateType = delegateType;
        this.classUnderTest = classUnderTest;
        this.testMethods = testMethods;
    }

    private void testDelegateMethod(TestMethod testMethod) throws Exception {
        Object returnValue = null;
        if (testMethod.returnType != null) {
            returnValue = EasyMock.createStrictMock((Class)testMethod.returnType);
        }
        Object delegate = EasyMock.createStrictMock(this.delegateType);
        Method method = delegate.getClass().getMethod(testMethod.name, testMethod.parameterTypes);
        method.invoke(delegate, testMethod.parameters);
        if (testMethod.returnType != null) {
            EasyMock.expectLastCall().andReturn(returnValue);
        } else {
            EasyMock.expectLastCall();
        }
        if (testMethod.returnType != null) {
            EasyMock.replay((Object[])new Object[]{returnValue});
        }
        EasyMock.replay((Object[])new Object[]{delegate});
        Object instanceUnderTest = this.createInstanceUnderTest(delegate);
        Method delegateMethod = instanceUnderTest.getClass().getMethod(testMethod.name, testMethod.parameterTypes);
        Object actualReturnValue = delegateMethod.invoke(instanceUnderTest, testMethod.parameters);
        if (testMethod.returnType != null) {
            Assert.assertEquals((Object)returnValue, (Object)actualReturnValue);
            EasyMock.verify((Object[])new Object[]{returnValue});
        }
        EasyMock.verify((Object[])new Object[]{delegate});
    }

    private Object createInstanceUnderTest(Object delegate) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = this.classUnderTest.getConstructor(this.delegateType);
        Object instanceUnderTest = constructor.newInstance(delegate);
        return instanceUnderTest;
    }

    @Test
    public void testDelegateMethods() throws Exception {
        for (TestMethod testMethod : this.testMethods) {
            try {
                this.testDelegateMethod(testMethod);
            }
            catch (Exception e) {
                String msg = "Error testing delegate method " + testMethod.name + "(" + Arrays.toString(testMethod.parameterTypes) + "): " + e.toString();
                System.err.println(msg);
                e.printStackTrace();
                Assert.fail((String)msg);
            }
        }
    }

    public static class TestMethod {
        private final String name;
        private final Class<?> returnType;
        private final Class<?>[] parameterTypes;
        private final Object[] parameters;

        public TestMethod(String name, Class<?> returnType, Class<?>[] parameterTypes, Object[] parameters) {
            this.name = name;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
            this.parameters = parameters;
        }

        public TestMethod(String name, Class<?>[] parameterTypes, Object[] parameters) {
            this(name, null, parameterTypes, parameters);
        }
    }
}

