/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec;

import de.mklinger.commons.exec.CmdException;
import de.mklinger.commons.exec.ErrorHandlingRunnable;
import de.mklinger.commons.exec.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeRunnable
extends ErrorHandlingRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(PipeRunnable.class);
    private final OutputStream out;
    private final InputStream in;
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicBoolean started = new AtomicBoolean();
    private volatile Thread runningThread;

    public PipeRunnable(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    protected void doRun() throws IOException {
        this.runningThread = Thread.currentThread();
        this.running.set(true);
        this.started.set(true);
        try {
            int copied = IOUtils.copy(this.in, this.out);
            LOG.debug("Copied {} bytes", (Object)copied);
        }
        finally {
            this.running.set(false);
            this.runningThread = null;
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void waitForStart(long timeoutMillis) throws CmdException {
        long start = System.currentTimeMillis();
        while (!this.started.get()) {
            if (start + timeoutMillis < System.currentTimeMillis()) {
                throw new CmdException("Timout waiting for pipe to start after " + timeoutMillis + " ms");
            }
            Thread.yield();
        }
    }

    public void waitForStop(long timeoutMillis) throws CmdException, InterruptedException {
        long start = System.currentTimeMillis();
        while (this.isRunning()) {
            if (start + timeoutMillis < System.currentTimeMillis()) {
                throw new CmdException("Timout waiting for pipe to stop after " + timeoutMillis + " ms");
            }
            Thread.sleep(1L);
        }
    }

    public void interrupt() {
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
    }

    public void closeIn() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

