/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec;

import de.mklinger.commons.exec.CmdBuilderBase;
import de.mklinger.commons.exec.CmdSettings;
import de.mklinger.commons.exec.JavaHome;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class JavaCmdBuilderBase<B extends CmdBuilderBase<B>>
extends CmdBuilderBase<B> {
    private String javaExecutable;
    private List<String> javaOpts;
    private StringBuilder modulePath;
    private StringBuilder upgradeModulePath;
    private StringBuilder modules;
    private static volatile String defaultJavaExecutable;

    public B javaExecutable(String javaExecutable) {
        this.javaExecutable = javaExecutable;
        return this.getBuilder();
    }

    public B javaExecutableFromRuntime() {
        JavaHome javaHome = JavaHome.getByRuntime();
        if (javaHome == null) {
            throw new IllegalStateException("No valid current JavaRuntime could be determined!");
        }
        File javaExecFile = javaHome.getJavaExecutable();
        if (javaExecFile == null) {
            throw new IllegalStateException("Current Java-runtime is valid, but no executable 'java' file could be found in javaHome: " + javaHome.getJavaHome().getAbsolutePath());
        }
        this.javaExecutable = javaExecFile.getAbsolutePath();
        return this.getBuilder();
    }

    public B systemProperty(String name, String value) {
        String key = "-D" + name;
        this.addJavaOption(key, value, true);
        return this.getBuilder();
    }

    public B systemProperty(String name) {
        String key = "-D" + name;
        this.addJavaOption(key, "", false);
        return this.getBuilder();
    }

    public B xmx(String value) {
        String key = "-Xmx";
        this.addJavaOption("-Xmx", value, false);
        return this.getBuilder();
    }

    public B xms(String value) {
        String key = "-Xms";
        this.addJavaOption("-Xms", value, false);
        return this.getBuilder();
    }

    public B xss(String value) {
        String key = "-Xss";
        this.addJavaOption("-Xss", value, false);
        return this.getBuilder();
    }

    public B maxPermSize(String value) {
        String key = "-XX:MaxPermSize";
        this.addJavaOption("-XX:MaxPermSize", value, true);
        return this.getBuilder();
    }

    public B bootClassPathPrepend(String ... bootClassPathAdditions) {
        if (bootClassPathAdditions == null || bootClassPathAdditions.length == 0) {
            return this.getBuilder();
        }
        String bootClassPathOption = this.buildBootClassPath("/p", bootClassPathAdditions);
        this.addJavaOption(bootClassPathOption);
        return this.getBuilder();
    }

    public B bootClassPathReplace(String ... bootClassPathEntries) {
        if (bootClassPathEntries == null || bootClassPathEntries.length == 0) {
            throw new IllegalArgumentException("BootClasspathEntries cannot be null or empty!");
        }
        String bootClassPathOption = this.buildBootClassPath("", bootClassPathEntries);
        this.addJavaOption(bootClassPathOption);
        return this.getBuilder();
    }

    public B bootClassPathAppend(String ... bootClassPathAdditions) {
        if (bootClassPathAdditions == null || bootClassPathAdditions.length == 0) {
            return this.getBuilder();
        }
        String bootClassPathOption = this.buildBootClassPath("/a", bootClassPathAdditions);
        this.addJavaOption(bootClassPathOption);
        return this.getBuilder();
    }

    private String buildBootClassPath(String bootClasspathPrefix, String ... bootClasspathAdditions) {
        StringBuilder sb = new StringBuilder("-Xbootclasspath").append(bootClasspathPrefix).append(":");
        for (String bootClasspathAddition : bootClasspathAdditions) {
            sb.append(bootClasspathAddition).append(File.pathSeparator);
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    private void addJavaOption(String key, String value, boolean useEquals) {
        String fullValue = useEquals ? key + "=" + value : key + value;
        this.addJavaOption(fullValue);
    }

    public B addJavaOption(String option) {
        if (this.javaOpts == null) {
            this.javaOpts = new LinkedList<String>();
        }
        this.javaOpts.add(option);
        return this.getBuilder();
    }

    public B modulePath(String ... modulePathEntries) {
        this.modulePath = JavaCmdBuilderBase.appendPathEntries(this.modulePath, modulePathEntries);
        return this.getBuilder();
    }

    public B upgradeModulePath(String ... upgradeModulePathEntries) {
        this.upgradeModulePath = JavaCmdBuilderBase.appendPathEntries(this.upgradeModulePath, upgradeModulePathEntries);
        return this.getBuilder();
    }

    private static StringBuilder appendPathEntries(StringBuilder path, String ... pathEntries) {
        if (pathEntries == null || pathEntries.length == 0) {
            return path;
        }
        if (path == null) {
            int size = pathEntries.length - 1;
            String[] stringArray = pathEntries;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String modulePathEntry = stringArray[i];
                size += modulePathEntry.length();
            }
            path = new StringBuilder(Math.max(16, size));
        }
        for (String modulePathEntry : pathEntries) {
            if (path.length() > 0) {
                path.append(File.pathSeparatorChar);
            }
            path.append(modulePathEntry);
        }
        return path;
    }

    public B addModule(String moduleName) {
        if (this.modules == null) {
            this.modules = new StringBuilder(Math.max(16, moduleName.length()));
        } else {
            this.modules.append(',');
        }
        this.modules.append(moduleName);
        return this.getBuilder();
    }

    @Override
    public CmdSettings toCmdSettings() {
        CmdSettings cmdSettings = super.toCmdSettings();
        List<String> additionalCommandParts = this.getJavaCommandParts();
        List<String> command = cmdSettings.getCommand();
        if (command == null) {
            cmdSettings.setCommand(additionalCommandParts);
        } else {
            command.addAll(0, additionalCommandParts);
        }
        return cmdSettings;
    }

    protected List<String> getJavaCommandParts() {
        LinkedList<String> additionalCommandParts = new LinkedList<String>();
        additionalCommandParts.add(this.getActualJavaExecutable());
        if (this.javaOpts != null) {
            Collections.sort(this.javaOpts);
            additionalCommandParts.addAll(this.javaOpts);
        }
        if (this.modulePath != null) {
            additionalCommandParts.add("--module-path");
            additionalCommandParts.add(this.modulePath.toString());
        }
        if (this.upgradeModulePath != null) {
            additionalCommandParts.add("--upgrade-module-path");
            additionalCommandParts.add(this.upgradeModulePath.toString());
        }
        if (this.modules != null) {
            additionalCommandParts.add("--add-modules");
            additionalCommandParts.add(this.modules.toString());
        }
        return additionalCommandParts;
    }

    private String getActualJavaExecutable() {
        if (this.javaExecutable != null) {
            return this.javaExecutable;
        }
        return JavaCmdBuilderBase.getDefaultJavaExecutable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getDefaultJavaExecutable() {
        if (defaultJavaExecutable != null) return defaultJavaExecutable;
        Class<JavaCmdBuilderBase> clazz = JavaCmdBuilderBase.class;
        synchronized (JavaCmdBuilderBase.class) {
            File java;
            if (defaultJavaExecutable != null) return defaultJavaExecutable;
            JavaHome javaHome = JavaHome.getJavaHomeByEnvironmentVariable();
            if (javaHome == null) {
                javaHome = JavaHome.getByRuntime();
            }
            if (javaHome != null && (java = javaHome.getJavaExecutable()) != null) {
                defaultJavaExecutable = java.getAbsolutePath();
            }
            defaultJavaExecutable = "java";
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultJavaExecutable;
        }
    }
}

