/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec;

import de.mklinger.commons.exec.CmdBuilder;
import de.mklinger.commons.exec.CmdException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdUtil {
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String OS_ARCH = System.getProperty("os.arch");
    private static final Logger LOG = LoggerFactory.getLogger(CmdUtil.class);

    public static String findExecutable(String ... executables) {
        for (String executable : executables) {
            String executablePath = CmdUtil.findExecutablePath(executable);
            if (executablePath == null) continue;
            return executablePath;
        }
        return null;
    }

    private static String findExecutablePath(String executable) {
        String executablePath = null;
        if (CmdUtil.isWindows()) {
            executablePath = CmdUtil.findExecutableWithCommand("where", executable);
            if (executablePath == null) {
                executablePath = CmdUtil.findExecutableBySystemPath(executable + ".exe");
            }
        } else {
            executablePath = CmdUtil.findExecutableWithCommand("which", executable);
            if (executablePath == null) {
                executablePath = CmdUtil.findExecutableWithCommand("bash", "-l", "-c", "which " + executable);
            }
        }
        if (executablePath == null) {
            executablePath = CmdUtil.findExecutableBySystemPath(executable);
        }
        if (executablePath == null) {
            LOG.info("Could not find {} executable on PATH", (Object)executable);
        } else {
            LOG.info("Found executable {} on PATH at location {}", (Object)executable, (Object)executablePath);
        }
        return executablePath;
    }

    private static String findExecutableBySystemPath(String executableName) {
        String path = System.getenv("PATH");
        if (path == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String pathEntry = st.nextToken();
            File candidate = new File(pathEntry, executableName);
            if (!candidate.exists() || !candidate.canExecute()) continue;
            return candidate.getAbsolutePath();
        }
        LOG.info("Executable not found on PATH: {}", (Object)path);
        return null;
    }

    private static String findExecutableWithCommand(String command, Object ... args) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ((CmdBuilder)new CmdBuilder(command).args(args)).toCmd().execute();
            return CmdUtil.extractExecutablePath(out.toString());
        }
        catch (CmdException e) {
            LOG.debug("Error trying to find executable with command", (Throwable)e);
            return null;
        }
    }

    private static String extractExecutablePath(String s) {
        String executablePath = s;
        if (executablePath == null) {
            return null;
        }
        if ((executablePath = executablePath.trim()).length() == 0) {
            return null;
        }
        File f = new File(executablePath);
        if (f.isFile() && f.canExecute()) {
            return executablePath;
        }
        return null;
    }

    public static String findWindowsProgramFilesExecutable(String executable, String ... subFolders) {
        File programFilesX86Dir;
        String programFilesX86;
        File programFilesDir;
        String path = null;
        String programFiles = System.getenv("ProgramFiles");
        if (programFiles != null && (programFilesDir = new File(programFiles)).isDirectory()) {
            LOG.info("Trying program files dierctory: {}", (Object)programFilesDir);
            path = CmdUtil.findWindowsProgramFilesExecutable(programFilesDir, executable, subFolders);
        }
        if (path == null && (programFilesX86 = System.getenv("ProgramFiles(x86)")) != null && (programFilesX86Dir = new File(programFilesX86)).isDirectory()) {
            LOG.info("Trying program files x86 dierctory: {}", (Object)programFilesX86);
            path = CmdUtil.findWindowsProgramFilesExecutable(programFilesX86Dir, executable, subFolders);
        }
        return path;
    }

    private static String findWindowsProgramFilesExecutable(File programFilesDir, String executable, String ... subFolders) {
        for (String subFolder : subFolders) {
            File executableFile = new File(programFilesDir, subFolder + File.separator + executable);
            if (!executableFile.exists() || !executableFile.canExecute()) continue;
            String path = executableFile.getAbsolutePath();
            LOG.info("Found windows program files executable at: {}", (Object)executableFile);
            return path;
        }
        return null;
    }

    public static String findMacOsXApplicationExecutable(String executable, String ... appNames) {
        File applicationsDir = new File("/Applications");
        if (!applicationsDir.exists() || !applicationsDir.canRead()) {
            return null;
        }
        for (String appName : appNames) {
            File executableCandidate = new File(applicationsDir, appName + "/Contents/MacOS/" + executable);
            if (!executableCandidate.exists() || !executableCandidate.canExecute()) continue;
            LOG.info("Found MacOSX applications executable at: {}", (Object)executableCandidate);
            return executableCandidate.getAbsolutePath();
        }
        return null;
    }

    public static boolean isWindows() {
        String osName = OS_NAME;
        return osName != null && osName.toLowerCase().startsWith("win");
    }

    public static boolean isMacOsX() {
        String osName = OS_NAME;
        return "Mac OS X".equalsIgnoreCase(osName);
    }

    public static boolean isLinux() {
        String osName = OS_NAME;
        return "Linux".equalsIgnoreCase(osName);
    }

    public static boolean is64bit() {
        String arch = OS_ARCH;
        return arch != null && arch.contains("64");
    }
}

