/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec;

import de.mklinger.commons.exec.Pingable;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdSettings {
    private static final Logger LOG = LoggerFactory.getLogger(CmdSettings.class);
    private Supplier<Executor> executorSupplier;
    private List<String> command;
    private File directory;
    private int expectedExitValue = 0;
    private OutputStream stdout;
    private File stdoutFile;
    private OutputStream stderr;
    private File stderrFile;
    private boolean redirectErrorStream = false;
    private Pingable pingable = null;
    private byte[] stdinBytes;
    private Map<String, String> environment;
    private long timeout;
    private boolean destroyOnError = true;
    private boolean destroyOnShutdown = true;
    private boolean destroyForcibly = false;
    private boolean frozen;

    public CmdSettings() {
    }

    public CmdSettings(CmdSettings cmdSettings) {
        if (cmdSettings.command != null) {
            this.command = new ArrayList<String>(cmdSettings.command);
        }
        this.directory = cmdSettings.directory;
        this.expectedExitValue = cmdSettings.expectedExitValue;
        this.stdout = cmdSettings.stdout;
        this.stdoutFile = cmdSettings.stdoutFile;
        this.stderr = cmdSettings.stderr;
        this.stderrFile = cmdSettings.stderrFile;
        this.redirectErrorStream = cmdSettings.redirectErrorStream;
        this.pingable = cmdSettings.pingable;
        if (cmdSettings.stdinBytes != null) {
            this.stdinBytes = new byte[cmdSettings.stdinBytes.length];
            System.arraycopy(cmdSettings.stdinBytes, 0, this.stdinBytes, 0, cmdSettings.stdinBytes.length);
        }
        if (cmdSettings.environment != null) {
            this.environment = new HashMap<String, String>(cmdSettings.environment);
        }
        this.timeout = cmdSettings.timeout;
        this.destroyOnError = cmdSettings.destroyOnError;
        this.destroyOnShutdown = cmdSettings.destroyOnShutdown;
        this.destroyForcibly = cmdSettings.destroyForcibly;
        this.executorSupplier = cmdSettings.executorSupplier;
    }

    public List<String> getCommand() {
        if (this.frozen && this.command != null) {
            return Collections.unmodifiableList(this.command);
        }
        return this.command;
    }

    public void setCommand(List<String> command) {
        this.checkFrozen();
        this.command = command;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.checkFrozen();
        this.directory = directory;
    }

    public int getExpectedExitValue() {
        return this.expectedExitValue;
    }

    public void setExpectedExitValue(int expectedExitValue) {
        this.checkFrozen();
        this.expectedExitValue = expectedExitValue;
    }

    public OutputStream getStdout() {
        return this.stdout;
    }

    public void setStdout(OutputStream stdout) {
        this.checkFrozen();
        if (this.stdoutFile != null) {
            LOG.warn("Setting stdout stream when stdout file is already set");
        }
        this.stdout = stdout;
    }

    public File getStdoutFile() {
        return this.stdoutFile;
    }

    public void setStdoutFile(File stdoutFile) {
        this.checkFrozen();
        if (this.stdout != null) {
            LOG.warn("Setting stdout file when stdout stream is already set");
        }
        this.stdoutFile = stdoutFile;
    }

    public OutputStream getStderr() {
        return this.stderr;
    }

    public void setStderr(OutputStream stderr) {
        this.checkFrozen();
        if (this.stderrFile != null) {
            LOG.warn("Setting stderr stream when stdout file is already set");
        }
        this.stderr = stderr;
    }

    public File getStderrFile() {
        return this.stderrFile;
    }

    public void setStderrFile(File stderrFile) {
        this.checkFrozen();
        if (this.stderr != null) {
            LOG.warn("Setting stderr file when stderr stream is already set");
        }
        this.stderrFile = stderrFile;
    }

    public void setRedirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
    }

    public boolean isRedirectErrorStream() {
        return this.redirectErrorStream;
    }

    public Pingable getPingable() {
        return this.pingable;
    }

    public void setPingable(Pingable pingable) {
        this.checkFrozen();
        this.pingable = pingable;
    }

    public byte[] getStdinBytes() {
        return this.stdinBytes;
    }

    public void setStdinBytes(byte[] stdinBytes) {
        this.checkFrozen();
        this.stdinBytes = stdinBytes;
    }

    public Map<String, String> getEnvironment() {
        if (this.frozen && this.environment != null) {
            return Collections.unmodifiableMap(this.environment);
        }
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.checkFrozen();
        this.environment = environment;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.checkFrozen();
        this.timeout = timeout;
    }

    public boolean isDestroyOnError() {
        return this.destroyOnError;
    }

    public void setDestroyOnError(boolean destroyOnError) {
        this.checkFrozen();
        this.destroyOnError = destroyOnError;
    }

    public boolean isDestroyOnShutdown() {
        return this.destroyOnShutdown;
    }

    public void setDestroyOnShutdown(boolean destroyOnShutdown) {
        this.checkFrozen();
        this.destroyOnShutdown = destroyOnShutdown;
    }

    public boolean isDestroyForcibly() {
        return this.destroyForcibly;
    }

    public void setDestroyForcibly(boolean destroyForcibly) {
        this.checkFrozen();
        this.destroyForcibly = destroyForcibly;
    }

    public void setExecutorSupplier(Supplier<Executor> executorSupplier) {
        this.checkFrozen();
        this.executorSupplier = executorSupplier;
    }

    public Supplier<Executor> getExecutorSupplier() {
        return this.executorSupplier;
    }

    public void freeze() {
        this.frozen = true;
    }

    private void checkFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("Instance is frozen");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("[command=");
        if (this.command != null) {
            boolean first = true;
            for (String part : this.command) {
                if (!first) {
                    sb.append(' ');
                } else {
                    first = false;
                }
                sb.append(part);
            }
        }
        return sb.toString();
    }
}

