/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec;

import de.mklinger.commons.exec.Cmd;
import de.mklinger.commons.exec.CmdBuilderBase;
import de.mklinger.commons.exec.CmdException;
import de.mklinger.commons.exec.CmdOutputException;
import de.mklinger.commons.exec.CmdSettings;
import de.mklinger.commons.exec.io.SynchronizedOutputStream;
import de.mklinger.commons.exec.io.TeeOutputStream;
import de.mklinger.commons.exec.io.UnsynchronizedStringWriter;
import de.mklinger.commons.exec.io.WriterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;

public class CmdOutputUtil {
    public static String executeForStdout(CmdBuilderBase<?> cmdBuilder) throws CmdException {
        return CmdOutputUtil.executeForStdout(cmdBuilder.toCmdSettings());
    }

    public static String executeForStdout(CmdSettings cmdSettings) throws CmdException {
        CmdSettings cs = new CmdSettings(cmdSettings);
        UnsynchronizedStringWriter sw = new UnsynchronizedStringWriter();
        SynchronizedOutputStream wout = new SynchronizedOutputStream(new WriterOutputStream((Writer)sw, Charset.defaultCharset()));
        if (cs.getStdout() == null) {
            cs.setStdout(wout);
        } else {
            cs.setStdout(new TeeOutputStream(cs.getStdout(), wout));
        }
        cs.freeze();
        try {
            new Cmd(cs).execute();
        }
        catch (CmdException e) {
            throw new CmdOutputException(e, CmdOutputUtil.getOutput(sw, wout), true, false);
        }
        return CmdOutputUtil.getOutput(sw, wout);
    }

    public static String executeForStderr(CmdBuilderBase<?> cmdBuilder) throws CmdException {
        return CmdOutputUtil.executeForStderr(cmdBuilder.toCmdSettings());
    }

    public static String executeForStderr(CmdSettings cmdSettings) throws CmdException {
        if (cmdSettings.isRedirectErrorStream()) {
            throw new IllegalArgumentException("Error stream is redirected");
        }
        CmdSettings cs = new CmdSettings(cmdSettings);
        UnsynchronizedStringWriter sw = new UnsynchronizedStringWriter();
        SynchronizedOutputStream wout = new SynchronizedOutputStream(new WriterOutputStream((Writer)sw, Charset.defaultCharset()));
        if (cs.getStderr() == null) {
            cs.setStderr(wout);
        } else {
            cs.setStderr(new TeeOutputStream(cs.getStderr(), wout));
        }
        cs.freeze();
        try {
            new Cmd(cs).execute();
        }
        catch (CmdException e) {
            throw new CmdOutputException(e, CmdOutputUtil.getOutput(sw, wout), false, true);
        }
        return CmdOutputUtil.getOutput(sw, wout);
    }

    public static String executeForOutput(CmdBuilderBase<?> cmdBuilder) throws CmdException {
        return CmdOutputUtil.executeForOutput(cmdBuilder.toCmdSettings());
    }

    public static String executeForOutput(CmdSettings cmdSettings) throws CmdException {
        if (cmdSettings.isRedirectErrorStream()) {
            return CmdOutputUtil.executeForStdout(cmdSettings);
        }
        CmdSettings cs = new CmdSettings(cmdSettings);
        UnsynchronizedStringWriter sw = new UnsynchronizedStringWriter();
        SynchronizedOutputStream wout = new SynchronizedOutputStream(new WriterOutputStream((Writer)sw, Charset.defaultCharset()));
        if (cs.getStderr() == null) {
            cs.setStderr(wout);
        } else {
            cs.setStderr(new TeeOutputStream(cs.getStderr(), wout));
        }
        if (cs.getStdout() == null) {
            cs.setStdout(wout);
        } else {
            cs.setStdout(new TeeOutputStream(cs.getStdout(), wout));
        }
        cs.freeze();
        try {
            new Cmd(cs).execute();
        }
        catch (CmdException e) {
            throw new CmdOutputException(e, CmdOutputUtil.getOutput(sw, wout), true, true);
        }
        return CmdOutputUtil.getOutput(sw, wout);
    }

    private static String getOutput(UnsynchronizedStringWriter sw, OutputStream wout) {
        try {
            wout.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return sw.toString();
    }
}

