/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec;

import de.mklinger.commons.exec.CmdException;
import de.mklinger.commons.exec.CmdInterruptedException;
import de.mklinger.commons.exec.CmdSettings;
import de.mklinger.commons.exec.DefaultExecutorSupplier;
import de.mklinger.commons.exec.ExitCodeException;
import de.mklinger.commons.exec.NullFile;
import de.mklinger.commons.exec.PingRunnable;
import de.mklinger.commons.exec.PipeRunnable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cmd {
    private static final Logger LOG = LoggerFactory.getLogger(Cmd.class);
    private static final Supplier<Executor> DEFAULT_EXECUTOR_SUPPLIER = new DefaultExecutorSupplier();
    private static final long PIPE_RUNNABLE_START_TIMEOUT = 1000L;
    private static final long PIPE_RUNNABLE_STOP_TIMEOUT = 60000L;
    private static final Set<Cmd> destroyOnShutdownCmds = new HashSet<Cmd>();
    private final CmdSettings cmdSettings;
    private NullFile stdOutNullFile = null;
    private NullFile stdErrNullFile = null;
    private PipeRunnable stdoutPipe = null;
    private PipeRunnable stderrPipe = null;
    private PingRunnable pingRunnable;
    private Process process;
    private long startTime;

    public Cmd(CmdSettings cmdSettings) {
        this.cmdSettings = cmdSettings;
    }

    public void execute() throws CmdException {
        try {
            this.start();
            this.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CmdInterruptedException(e);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws CmdException {
        List<String> command = this.cmdSettings.getCommand();
        if (command == null || this.cmdSettings.getCommand().isEmpty()) {
            throw new IllegalArgumentException("Missing command");
        }
        this.logCommandLine(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        if (this.cmdSettings.getDirectory() != null) {
            pb.directory(this.cmdSettings.getDirectory());
        }
        if (this.cmdSettings.getEnvironment() != null) {
            pb.environment().clear();
            pb.environment().putAll(this.cmdSettings.getEnvironment());
        }
        if (this.cmdSettings.getStdout() == null) {
            if (this.cmdSettings.getStdoutFile() != null) {
                pb.redirectOutput(ProcessBuilder.Redirect.to(this.cmdSettings.getStdoutFile()));
            } else {
                try {
                    this.stdOutNullFile = new NullFile();
                }
                catch (IOException e) {
                    throw new CmdException("Error creating null file", e);
                }
                pb.redirectOutput(ProcessBuilder.Redirect.to(this.stdOutNullFile.getFile()));
            }
        }
        if (!this.cmdSettings.isRedirectErrorStream() && this.cmdSettings.getStderr() == null) {
            if (this.cmdSettings.getStderrFile() != null) {
                pb.redirectError(ProcessBuilder.Redirect.to(this.cmdSettings.getStderrFile()));
            } else {
                try {
                    this.stdErrNullFile = new NullFile();
                }
                catch (IOException e) {
                    throw new CmdException("Error creating null file", e);
                }
                pb.redirectError(ProcessBuilder.Redirect.to(this.stdErrNullFile.getFile()));
            }
        }
        if (this.cmdSettings.isRedirectErrorStream()) {
            pb.redirectErrorStream(true);
        }
        try {
            this.process = pb.start();
        }
        catch (IOException e) {
            throw new CmdException(e);
        }
        this.startTime = System.currentTimeMillis();
        if (this.cmdSettings.isDestroyOnShutdown()) {
            Set<Cmd> e = destroyOnShutdownCmds;
            synchronized (e) {
                destroyOnShutdownCmds.add(this);
            }
        }
        if (this.cmdSettings.getPingable() != null) {
            this.pingRunnable = new PingRunnable(this.cmdSettings.getPingable());
            this.execute(this.pingRunnable);
        }
        if (this.cmdSettings.getStdout() != null) {
            this.stdoutPipe = new PipeRunnable(this.process.getInputStream(), this.cmdSettings.getStdout());
            this.execute(this.stdoutPipe);
            this.stdoutPipe.waitForStart(1000L);
        }
        if (!this.cmdSettings.isRedirectErrorStream() && this.cmdSettings.getStderr() != null) {
            this.stderrPipe = new PipeRunnable(this.process.getErrorStream(), this.cmdSettings.getStderr());
            this.execute(this.stderrPipe);
            this.stderrPipe.waitForStart(1000L);
        }
        if (this.cmdSettings.getStdinBytes() != null) {
            try {
                OutputStream pout = this.process.getOutputStream();
                pout.write(this.cmdSettings.getStdinBytes());
                pout.close();
            }
            catch (IOException e) {
                throw new CmdException("Error writing to stdin", e);
            }
        }
    }

    private void logCommandLine(List<String> command) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing: {}", (Object)this.toBashCommandLine(command));
        }
    }

    private String toBashCommandLine(List<String> command) {
        return command.stream().map(s -> s.replace("'", "'\"'\"'")).collect(Collectors.joining("' '", "'", "'"));
    }

    private void execute(Runnable runnable) {
        Supplier<Executor> executorSupplier = this.cmdSettings.getExecutorSupplier();
        if (executorSupplier == null) {
            executorSupplier = DEFAULT_EXECUTOR_SUPPLIER;
        }
        executorSupplier.get().execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitFor() throws CmdException, InterruptedException {
        int exitValue;
        block22: {
            try {
                try {
                    Exception throwedException = null;
                    try {
                        try {
                            exitValue = this.doWaitFor();
                            if (!this.cmdSettings.isDestroyOnShutdown()) break block22;
                            Set<Cmd> set = destroyOnShutdownCmds;
                            synchronized (set) {
                                destroyOnShutdownCmds.remove(this);
                            }
                        }
                        catch (Exception e) {
                            throwedException = this.handleExecutionException(throwedException, e);
                            throw throwedException;
                        }
                        finally {
                            this.stopPipe(this.stdoutPipe, "stdout", 60000L, throwedException);
                        }
                    }
                    finally {
                        this.stopPipe(this.stderrPipe, "stderr", 60000L, throwedException);
                    }
                }
                finally {
                    if (this.pingRunnable != null) {
                        this.pingRunnable.interrupt();
                    }
                }
            }
            catch (CmdException | InterruptedException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CmdException(e);
            }
            finally {
                this.pingRunnable = null;
                this.stdoutPipe = null;
                this.stderrPipe = null;
                this.process = null;
            }
        }
        if (exitValue != this.cmdSettings.getExpectedExitValue()) {
            throw new ExitCodeException("Error executing command: " + this.cmdSettings.getCommand() + ". Exit value: " + exitValue, this.cmdSettings.getExpectedExitValue(), exitValue);
        }
        return exitValue;
    }

    private void stopPipe(PipeRunnable pipe, String name, long timeout, Exception throwedException) throws Exception {
        block7: {
            try {
                if (pipe == null) break block7;
                pipe.waitForStop(timeout);
                if (pipe.getError() == null) break block7;
                CmdException ex = new CmdException("Error reading " + name, pipe.getError());
                if (throwedException != null) {
                    throwedException.addSuppressed(ex);
                    break block7;
                }
                throwedException = ex;
                throw ex;
            }
            catch (Exception e) {
                throwedException = this.handleExecutionException(throwedException, e);
                throw throwedException;
            }
            finally {
                if (pipe != null) {
                    pipe.interrupt();
                }
            }
        }
    }

    private Exception handleExecutionException(Exception mainException, Exception newException) {
        Exception e = this.withSuppressed(mainException, newException);
        if (this.cmdSettings.isDestroyOnError()) {
            LOG.trace("Destroying on error", (Throwable)e);
            this.destroy();
        }
        if (newException instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        return e;
    }

    private Exception withSuppressed(Exception mainException, Exception newException) {
        if (mainException == null) {
            return newException;
        }
        if (mainException != newException) {
            mainException.addSuppressed(newException);
        }
        return mainException;
    }

    private int doWaitFor() throws InterruptedException, CmdException {
        if (this.cmdSettings.getTimeout() < 1L && !this.cmdSettings.isDestroyOnError()) {
            return this.process.waitFor();
        }
        while (this.cmdSettings.getTimeout() < 1L || System.currentTimeMillis() < this.startTime + this.cmdSettings.getTimeout()) {
            if (this.cmdSettings.isDestroyOnError()) {
                this.checkErrorHandlingRunnables();
            }
            try {
                return this.process.exitValue();
            }
            catch (IllegalThreadStateException e) {
                Thread.sleep(10L);
            }
        }
        this.destroyProcess();
        throw new CmdException("Timeout: command execution took longer than " + this.cmdSettings.getTimeout() + "ms");
    }

    private void checkErrorHandlingRunnables() throws CmdException {
        if (this.stderrPipe != null && this.stderrPipe.getError() != null) {
            throw new CmdException("Error in stderr pipe", this.stderrPipe.getError());
        }
        if (this.stdoutPipe != null && this.stdoutPipe.getError() != null) {
            throw new CmdException("Error in stdout pipe", this.stdoutPipe.getError());
        }
        if (this.pingRunnable != null && this.pingRunnable.getError() != null) {
            throw new CmdException("Error in ping runnable", this.pingRunnable.getError());
        }
    }

    public void close() {
        this.destroy();
    }

    public void destroy() {
        this.destroy(this.cmdSettings.isDestroyForcibly());
    }

    public void destroyForcibly() {
        this.destroy(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(boolean force) {
        Exception throwedException;
        block46: {
            throwedException = null;
            try {
                if (force) {
                    this.destroyProcessForcibly();
                } else {
                    this.destroyProcess();
                }
            }
            catch (Exception e) {
                throwedException = this.withSuppressed(throwedException, e);
            }
            try {
                if (this.pingRunnable != null) {
                    this.pingRunnable.interrupt();
                }
            }
            catch (Exception e) {
                throwedException = this.withSuppressed(throwedException, e);
            }
            finally {
                this.pingRunnable = null;
            }
            try {
                if (this.stdoutPipe != null) {
                    this.stdoutPipe.interrupt();
                    this.stdoutPipe.closeIn();
                }
            }
            catch (Exception e) {
                throwedException = this.withSuppressed(throwedException, e);
            }
            finally {
                this.stdoutPipe = null;
            }
            try {
                if (this.stderrPipe != null) {
                    this.stderrPipe.interrupt();
                    this.stderrPipe.closeIn();
                }
            }
            catch (Exception e) {
                throwedException = this.withSuppressed(throwedException, e);
            }
            finally {
                this.stderrPipe = null;
            }
            try {
                if (this.stdOutNullFile != null) {
                    this.stdOutNullFile.cleanup();
                }
            }
            catch (Exception e) {
                throwedException = this.withSuppressed(throwedException, e);
            }
            finally {
                this.stdOutNullFile = null;
            }
            try {
                if (this.stdErrNullFile != null) {
                    this.stdErrNullFile.cleanup();
                }
            }
            catch (Exception e) {
                throwedException = this.withSuppressed(throwedException, e);
            }
            finally {
                this.stdErrNullFile = null;
            }
            try {
                if (!this.cmdSettings.isDestroyOnShutdown()) break block46;
                Set<Cmd> e = destroyOnShutdownCmds;
                synchronized (e) {
                    destroyOnShutdownCmds.remove(this);
                }
            }
            catch (Exception e) {
                throwedException = this.withSuppressed(throwedException, e);
            }
        }
        if (throwedException != null) {
            if (throwedException instanceof RuntimeException) {
                throw (RuntimeException)throwedException;
            }
            throw new RuntimeException(throwedException);
        }
    }

    private void destroyProcess() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private void destroyProcessForcibly() {
        if (this.process != null) {
            this.process.destroyForcibly();
        }
    }

    public boolean isExecuting() {
        if (this.process == null) {
            return false;
        }
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public int exitValue() {
        if (this.process == null) {
            throw new IllegalThreadStateException("No process");
        }
        return this.process.exitValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("[command=");
        if (this.cmdSettings.getCommand() != null) {
            boolean first = true;
            for (String part : this.cmdSettings.getCommand()) {
                if (!first) {
                    sb.append(' ');
                } else {
                    first = false;
                }
                sb.append(part);
            }
        }
        return sb.toString();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet cmds;
                Set set = destroyOnShutdownCmds;
                synchronized (set) {
                    cmds = new HashSet(destroyOnShutdownCmds);
                    destroyOnShutdownCmds.clear();
                }
                for (Cmd cmd : cmds) {
                    cmd.destroy();
                }
            }
        });
    }
}

