/*
 * Decompiled with CFR 0.152.
 */
package de.m3y.prometheus.client.webapp;

import de.m3y.prometheus.client.webapp.BuildMetaInfo;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Info;
import io.prometheus.client.hotspot.DefaultExports;
import io.prometheus.jmx.JmxCollector;
import java.io.File;
import java.io.IOException;
import javax.management.MalformedObjectNameException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ConfigurationServletContextListener
implements ServletContextListener {
    public static final String JMX_COLLECTOR_CONFIG_FILE = "jmx_collector_config_file";
    private final Info buildInfo = ((Info.Builder)((Info.Builder)((Info.Builder)Info.build().name("prometheus_webapp_build")).help("Prometheus webapp build info")).labelNames(new String[]{"version", "buildTime", "buildScmVersion", "buildScmBranch"})).create();
    private JmxCollector jmxCollector;

    public void contextInitialized(ServletContextEvent sce) {
        DefaultExports.initialize();
        this.jmxCollector = this.initializeJmxCollector(sce);
        if (null != this.jmxCollector) {
            this.jmxCollector.register();
        }
        this.buildInfo.labels(new String[]{BuildMetaInfo.INSTANCE.getVersion(), BuildMetaInfo.INSTANCE.getBuildTimeStamp(), BuildMetaInfo.INSTANCE.getBuildScmVersion(), BuildMetaInfo.INSTANCE.getBuildScmBranch()});
        this.buildInfo.register();
    }

    protected String getJmxCollectorConfigFile(ServletContextEvent sce) {
        String configFile = System.getProperty(JMX_COLLECTOR_CONFIG_FILE, "").trim();
        if (!configFile.isEmpty()) {
            return configFile;
        }
        configFile = sce.getServletContext().getInitParameter(JMX_COLLECTOR_CONFIG_FILE);
        if (null != configFile && !configFile.trim().isEmpty()) {
            return configFile;
        }
        return null;
    }

    protected JmxCollector initializeJmxCollector(ServletContextEvent sce) {
        String configFile = this.getJmxCollectorConfigFile(sce);
        if (null != configFile && !configFile.isEmpty()) {
            File file = new File(configFile);
            if (!file.exists()) {
                throw new IllegalStateException("Config file " + file.getAbsolutePath() + " does not exist but is set via system property " + JMX_COLLECTOR_CONFIG_FILE + ". Please verify file.");
            }
            try {
                return new JmxCollector(file);
            }
            catch (IOException e) {
                throw new IllegalStateException("Can not initialize JMX Collector using config file " + configFile, e);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalStateException("Can not initialize JMX Collector", e);
            }
        }
        String config = sce.getServletContext().getInitParameter("jmx_collector_config");
        if (null != config && !config.trim().isEmpty()) {
            try {
                return new JmxCollector(config);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalStateException("Can not initialize JMX Collector using config <" + config + ">", e);
            }
        }
        return null;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (null != this.jmxCollector) {
            CollectorRegistry.defaultRegistry.unregister((Collector)this.jmxCollector);
        }
        CollectorRegistry.defaultRegistry.unregister((Collector)this.buildInfo);
    }
}

