/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.core;

import de.jiac.micro.core.ILifecycleAware;
import de.jiac.micro.util.List;
import org.slf4j.Logger;

public final class LifecycleHandler {
    private LifecycleHandler() {
    }

    public static boolean makeTransitionsTo(ILifecycleAware la, byte currentState, byte targetState, Logger logger) {
        boolean debug;
        if (currentState == targetState || currentState == 0) {
            return false;
        }
        boolean down = targetState < currentState;
        boolean bl = debug = logger != null && logger.isDebugEnabled();
        while (currentState != targetState) {
            currentState = (byte)(currentState + (down ? -1 : 1));
            if (la == null) continue;
            try {
                switch (currentState) {
                    case 1: {
                        if (!down) break;
                        if (debug) {
                            logger.debug("cleaning up " + la);
                        }
                        la.cleanup();
                        break;
                    }
                    case 2: {
                        if (down) {
                            if (debug) {
                                logger.debug("stopping " + la);
                            }
                            la.stop();
                            break;
                        }
                        if (debug) {
                            logger.debug("initialising " + la);
                        }
                        la.initialise();
                        break;
                    }
                    case 3: {
                        if (down) break;
                        if (debug) {
                            logger.debug("starting " + la);
                        }
                        la.start();
                    }
                }
            }
            catch (RuntimeException re) {
                if (logger == null) continue;
                logger.warn("corrupted state change", (Throwable)re);
            }
        }
        return true;
    }

    public static boolean makeTransitionsTo(ILifecycleContext context, byte targetState, Logger logger) {
        boolean result = LifecycleHandler.makeTransitionsTo(context.lifecycleAware(), context.lifecycleState(), targetState, logger);
        if (result) {
            if (context instanceof SimpleLifecycleContext) {
                ((SimpleLifecycleContext)context).lifecycleState = targetState;
            } else if (context instanceof ListableLifecycleContext) {
                ((ListableLifecycleContext)context).lifecycleState = targetState;
            }
        }
        return result;
    }

    public static class ListableLifecycleContext
    extends List.Node
    implements ILifecycleContext {
        byte lifecycleState = 1;

        public final ILifecycleAware lifecycleAware() {
            Object value = this.value();
            return value instanceof ILifecycleAware ? (ILifecycleAware)value : null;
        }

        public final byte lifecycleState() {
            return this.lifecycleState;
        }
    }

    public static class SimpleLifecycleContext
    implements ILifecycleContext {
        byte lifecycleState = 1;
        private final Object _la;

        public SimpleLifecycleContext(Object la) {
            this._la = la;
        }

        public ILifecycleAware lifecycleAware() {
            return this._la instanceof ILifecycleAware ? (ILifecycleAware)this._la : null;
        }

        public byte lifecycleState() {
            return this.lifecycleState;
        }
    }

    public static interface ILifecycleContext {
        public ILifecycleAware lifecycleAware();

        public byte lifecycleState();
    }

    public static interface LifecycleState {
        public static final byte CONSTRUCTED = 1;
        public static final byte INITIALISED = 2;
        public static final byte ACTIVE = 3;
        public static final byte DESTROYED = 0;
    }
}

