/*
 * Decompiled with CFR 0.152.
 */
package jflex.benchmark;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.TimeUnit;
import jflex.benchmark.NoAction;
import jflex.benchmark.pregen.NoAction17;
import jflex.benchmark.pregen.NoAction18;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime, Mode.SampleTime, Mode.SingleShotTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=3)
public class JFlexBench {
    @Benchmark
    public int noActionLexer(LexerState state) throws IOException {
        state.reader.reset();
        return new NoAction(state.reader).yylex();
    }

    @Benchmark
    public int noAction17Lexer(LexerState state) throws IOException {
        state.reader.reset();
        return new NoAction17(state.reader).yylex();
    }

    @Benchmark
    public int noAction18Lexer(LexerState state) throws IOException {
        state.reader.reset();
        return new NoAction18(state.reader).yylex();
    }

    public void baselineReader(LexerState state, Blackhole bh) throws IOException {
        char[] buffer = new char[state.length];
        state.reader.reset();
        state.reader.read(buffer, 0, buffer.length);
        int i = 0;
        while (i < buffer.length) {
            bh.consume(buffer[i]);
            ++i;
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JFlexBench.class.getSimpleName()).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Benchmark)
    public static class LexerState {
        @Param(value={"1000", "10000"})
        public int factor;
        @Param(value={"1", "2"})
        public int input;
        public int length;
        public Reader reader;

        @Setup
        public void setup() {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < 10 * this.factor) {
                switch (this.input) {
                    case 1: {
                        builder.append("aaa");
                        builder.append("bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb");
                        builder.append("  ");
                        break;
                    }
                    case 2: {
                        builder.append("\ud83d\ude0ea");
                        builder.append("\u3053\u306e\u30de\u30cb\u30e5\u30a2\u30eb\u306b\u3064\u3044\u3066bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb");
                        builder.append("  ");
                        break;
                    }
                    default: {
                        assert (false) : "reached unreachable default case";
                        break;
                    }
                }
                ++i;
            }
            this.length = builder.length();
            this.reader = new StringReader(builder.toString());
        }
    }
}

