/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.javolution;

import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import de.javakaffee.web.msm.TranscoderFactory;
import de.javakaffee.web.msm.serializer.javolution.CustomXMLFormat;
import de.javakaffee.web.msm.serializer.javolution.JavolutionTranscoder;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.catalina.Manager;

public class JavolutionTranscoderFactory
implements TranscoderFactory {
    private boolean _copyCollectionsForSerialization;
    private String[] _customConverterClassNames;
    private JavolutionTranscoder _transcoder;

    public SessionAttributesTranscoder createTranscoder(MemcachedSessionService.SessionManager manager) {
        return this.getTranscoder(manager);
    }

    private JavolutionTranscoder getTranscoder(MemcachedSessionService.SessionManager manager) {
        if (this._transcoder == null) {
            CustomXMLFormat<?>[] customFormats = this.loadCustomFormats(manager);
            this._transcoder = new JavolutionTranscoder((Manager)manager, this._copyCollectionsForSerialization, customFormats);
        }
        return this._transcoder;
    }

    private CustomXMLFormat<?>[] loadCustomFormats(MemcachedSessionService.SessionManager manager) {
        if (this._customConverterClassNames == null || this._customConverterClassNames.length == 0) {
            return null;
        }
        CustomXMLFormat[] customFormats = new CustomXMLFormat[this._customConverterClassNames.length];
        for (int i = 0; i < this._customConverterClassNames.length; ++i) {
            String className = this._customConverterClassNames[i];
            try {
                CustomXMLFormat xmlFormat;
                customFormats[i] = xmlFormat = Class.forName(className, true, manager.getContainerClassLoader()).asSubclass(CustomXMLFormat.class).newInstance();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load custom xml format " + className, e);
            }
        }
        return customFormats;
    }

    public void setCopyCollectionsForSerialization(boolean copyCollectionsForSerialization) {
        this._copyCollectionsForSerialization = copyCollectionsForSerialization;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public void setCustomConverterClassNames(String[] customConverterClassNames) {
        this._customConverterClassNames = customConverterClassNames;
    }
}

