/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.javolution;

import de.javakaffee.web.msm.serializer.javolution.CustomXMLFormat;
import de.javakaffee.web.msm.serializer.javolution.ReflectionFormat;
import de.javakaffee.web.msm.serializer.javolution.XMLArrayFormats;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javolution.lang.Reflection;
import javolution.text.CharArray;
import javolution.xml.XMLBinding;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReader;
import javolution.xml.stream.XMLStreamWriter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import sun.reflect.ReflectionFactory;

public class ReflectionBinding
extends XMLBinding {
    public static final String CLASS = "class";
    private static final long serialVersionUID = -7047053153745571559L;
    private static final Log LOG = LogFactory.getLog(ReflectionBinding.class);
    private static final ReflectionFactory REFLECTION_FACTORY = ReflectionFactory.getReflectionFactory();
    private static final Object[] INITARGS = new Object[0];
    private static final String SIZE = "size";
    private static final XMLCalendarFormat CALENDAR_FORMAT = new XMLCalendarFormat();
    private static final XMLCurrencyFormat CURRENCY_FORMAT = new XMLCurrencyFormat();
    private final Map<Class<?>, XMLFormat<?>> _formats = new ConcurrentHashMap();
    private final transient ClassLoader _classLoader;
    private final transient XMLEnumFormat _enumFormat;
    private final transient XMLArrayFormat _arrayFormat;
    private final transient XMLCollectionFormat _collectionFormat;
    private final transient XMLMapFormat _mapFormat;
    private final transient XMLJdkProxyFormat _jdkProxyFormat;
    private final transient CustomXMLFormat<?>[] _customFormats;
    public static final XMLFormat<StringBuilder> STRING_BUILDER_FORMAT = new XMLFormat<StringBuilder>(StringBuilder.class){

        public StringBuilder newInstance(Class<StringBuilder> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return new StringBuilder((CharSequence)xml.getAttribute("val"));
        }

        public void read(XMLFormat.InputElement xml, StringBuilder obj) throws XMLStreamException {
        }

        public void write(StringBuilder obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("val", obj.toString());
        }
    };
    public static final XMLFormat<StringBuffer> STRING_BUFFER_FORMAT = new XMLFormat<StringBuffer>(StringBuffer.class){

        public StringBuffer newInstance(Class<StringBuffer> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return new StringBuffer((CharSequence)xml.getAttribute("val"));
        }

        public void read(XMLFormat.InputElement xml, StringBuffer obj) throws XMLStreamException {
        }

        public void write(StringBuffer obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("val", obj.toString());
        }
    };

    public ReflectionBinding(ClassLoader classLoader) {
        this(classLoader, false, new CustomXMLFormat[0]);
    }

    public ReflectionBinding(ClassLoader classLoader, boolean copyCollectionsForSerialization, CustomXMLFormat<?> ... customFormats) {
        this._classLoader = classLoader;
        this._enumFormat = new XMLEnumFormat(classLoader);
        this._arrayFormat = new XMLArrayFormat(classLoader);
        this._collectionFormat = new XMLCollectionFormat(copyCollectionsForSerialization);
        this._mapFormat = new XMLMapFormat(copyCollectionsForSerialization);
        this._jdkProxyFormat = new XMLJdkProxyFormat(classLoader);
        this._customFormats = customFormats;
        Reflection.getInstance().add((Object)classLoader);
    }

    protected void writeClass(Class cls, XMLStreamWriter writer, boolean useAttributes) throws XMLStreamException {
        if (Proxy.isProxyClass(cls)) {
            cls = Proxy.class;
        }
        CustomXMLFormat<Proxy> xmlFormat = null;
        xmlFormat = this.getCustomFormat(cls);
        if (xmlFormat != null) {
            cls = xmlFormat.getTargetClass(cls);
        }
        if (useAttributes) {
            writer.writeAttribute((CharSequence)CLASS, (CharSequence)cls.getName());
        } else {
            writer.writeStartElement((CharSequence)cls.getName());
        }
    }

    protected Class readClass(XMLStreamReader reader, boolean useAttributes) throws XMLStreamException {
        CharArray className = useAttributes ? reader.getAttributeValue(null, (CharSequence)CLASS) : reader.getLocalName();
        try {
            return Class.forName(className.toString(), true, this._classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new XMLStreamException((Throwable)e);
        }
    }

    public XMLFormat<?> getFormat(Class cls) throws XMLStreamException {
        XMLFormat xmlFormat = this._formats.get(cls);
        if (xmlFormat != null) {
            return xmlFormat;
        }
        xmlFormat = this.getCustomFormat(cls);
        if (xmlFormat != null) {
            return xmlFormat;
        }
        if (cls.isPrimitive() || cls == String.class || cls == Boolean.class || cls == Integer.class || cls == Long.class || cls == Short.class || cls == Double.class || cls == Float.class || cls == Character.class || cls == Byte.class || cls == Class.class) {
            return super.getFormat(cls);
        }
        if (XMLSerializable.class.isAssignableFrom(cls)) {
            return super.getFormat(cls);
        }
        if (cls.isArray()) {
            return this.getArrayFormat(cls);
        }
        if (Collection.class.isAssignableFrom(cls) && Modifier.isPublic(cls.getModifiers())) {
            return this._collectionFormat;
        }
        if (Map.class.isAssignableFrom(cls) && Modifier.isPublic(cls.getModifiers())) {
            return this._mapFormat;
        }
        if (cls.isEnum()) {
            return this._enumFormat;
        }
        if (Calendar.class.isAssignableFrom(cls)) {
            return CALENDAR_FORMAT;
        }
        if (Currency.class.isAssignableFrom(cls)) {
            return CURRENCY_FORMAT;
        }
        if (Proxy.isProxyClass(cls) || cls == Proxy.class) {
            return this._jdkProxyFormat;
        }
        if (cls == StringBuilder.class) {
            return STRING_BUILDER_FORMAT;
        }
        if (cls == StringBuffer.class) {
            return STRING_BUFFER_FORMAT;
        }
        if (xmlFormat == null) {
            xmlFormat = ReflectionFormat.isNumberFormat(cls) ? ReflectionFormat.getNumberFormat(cls) : new ReflectionFormat(cls, this._classLoader);
            this._formats.put(cls, xmlFormat);
        }
        return xmlFormat;
    }

    private CustomXMLFormat<?> getCustomFormat(Class<?> cls) {
        if (this._customFormats == null) {
            return null;
        }
        for (CustomXMLFormat<?> xmlFormat : this._customFormats) {
            if (!xmlFormat.canConvert(cls)) continue;
            return xmlFormat;
        }
        return null;
    }

    private XMLFormat getArrayFormat(Class cls) {
        if (cls == int[].class) {
            return XMLArrayFormats.INT_ARRAY_FORMAT;
        }
        if (cls == long[].class) {
            return XMLArrayFormats.LONG_ARRAY_FORMAT;
        }
        if (cls == short[].class) {
            return XMLArrayFormats.SHORT_ARRAY_FORMAT;
        }
        if (cls == float[].class) {
            return XMLArrayFormats.FLOAT_ARRAY_FORMAT;
        }
        if (cls == double[].class) {
            return XMLArrayFormats.DOUBLE_ARRAY_FORMAT;
        }
        if (cls == char[].class) {
            return XMLArrayFormats.CHAR_ARRAY_FORMAT;
        }
        if (cls == byte[].class) {
            return XMLArrayFormats.BYTE_ARRAY_FORMAT;
        }
        return this._arrayFormat;
    }

    private static <T> T newInstanceFromPublicConstructor(Class<T> cls, XMLFormat.InputElement xml) throws XMLStreamException {
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = cls.getConstructors()) {
                CharArray size;
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length == 0) {
                    return (T)constructor.newInstance(new Object[0]);
                }
                if (parameterTypes.length != 1 || parameterTypes[0] != Integer.TYPE || (size = xml.getAttribute(SIZE)) == null) continue;
                return (T)constructor.newInstance(size.toInt());
            }
            if (LOG.isDebugEnabled() && constructors.length > 0) {
                LOG.debug((Object)("No suitable constructor found for map " + cls + ", available constructors:\n" + Arrays.asList(constructors)));
            }
        }
        catch (SecurityException constructors) {
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new XMLStreamException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new XMLStreamException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.info((Object)("Tried to invoke int constructor on " + cls.getName() + ", this threw an exception."), e.getTargetException());
        }
        return null;
    }

    public static final class XMLJdkProxyFormat
    extends XMLFormat<Object> {
        private final ClassLoader _classLoader;

        public XMLJdkProxyFormat(ClassLoader classLoader) {
            super(null);
            this._classLoader = classLoader;
        }

        public boolean isReferenceable() {
            return false;
        }

        public Object newInstance(Class<Object> clazz, XMLFormat.InputElement input) throws XMLStreamException {
            InvocationHandler invocationHandler = (InvocationHandler)input.get("handler");
            Class<?>[] interfaces = XMLJdkProxyFormat.getInterfaces(input, "interfaces", this._classLoader);
            return Proxy.newProxyInstance(this._classLoader, interfaces, invocationHandler);
        }

        public static Class<?>[] getInterfaces(XMLFormat.InputElement input, String elementName, ClassLoader classLoader) throws XMLStreamException {
            String[] interfaceNames = (String[])input.get(elementName);
            if (interfaceNames != null) {
                try {
                    Class[] interfaces = new Class[interfaceNames.length];
                    for (int i = 0; i < interfaceNames.length; ++i) {
                        interfaces[i] = Class.forName(interfaceNames[i], true, classLoader);
                    }
                    return interfaces;
                }
                catch (ClassNotFoundException e) {
                    throw new XMLStreamException((Throwable)e);
                }
            }
            return new Class[0];
        }

        public void read(XMLFormat.InputElement input, Object obj) throws XMLStreamException {
        }

        public final void write(Object obj, XMLFormat.OutputElement output) throws XMLStreamException {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(obj);
            output.add((Object)invocationHandler, "handler");
            String[] interfaceNames = XMLJdkProxyFormat.getInterfaceNames(obj);
            output.add((Object)interfaceNames, "interfaces");
        }

        public static String[] getInterfaceNames(Object obj) {
            Class<?>[] interfaces = obj.getClass().getInterfaces();
            if (interfaces != null) {
                String[] interfaceNames = new String[interfaces.length];
                for (int i = 0; i < interfaces.length; ++i) {
                    interfaceNames[i] = interfaces[i].getName();
                }
                return interfaceNames;
            }
            return new String[0];
        }
    }

    public static class XMLCalendarFormat
    extends XMLFormat<Calendar> {
        private final Field _zoneField;

        public XMLCalendarFormat() {
            super(Calendar.class);
            try {
                this._zoneField = Calendar.class.getDeclaredField("zone");
                this._zoneField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Calendar newInstance(Class<Calendar> clazz, XMLFormat.InputElement arg1) throws XMLStreamException {
            if (clazz.equals(GregorianCalendar.class)) {
                return GregorianCalendar.getInstance();
            }
            throw new IllegalArgumentException("Calendar of type " + clazz.getName() + " not yet supported. Please submit an issue so that it will be implemented.");
        }

        public void read(XMLFormat.InputElement xml, Calendar obj) throws XMLStreamException {
            String timeZoneId = xml.getAttribute("tz", "");
            if (!this.getTimeZone(obj).getID().equals(timeZoneId)) {
                obj.setTimeZone(TimeZone.getTimeZone(timeZoneId));
            }
            obj.setMinimalDaysInFirstWeek(xml.getAttribute("minimalDaysInFirstWeek", -1));
            obj.setFirstDayOfWeek(xml.getAttribute("firstDayOfWeek", -1));
            obj.setLenient(xml.getAttribute("lenient", true));
            obj.setTimeInMillis(xml.getAttribute("timeInMillis", -1L));
        }

        public void write(Calendar obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (!obj.getClass().equals(GregorianCalendar.class)) {
                throw new IllegalArgumentException("Calendar of type " + obj.getClass().getName() + " not yet supported. Please submit an issue so that it will be implemented.");
            }
            xml.setAttribute("timeInMillis", obj.getTimeInMillis());
            xml.setAttribute("lenient", obj.isLenient());
            xml.setAttribute("firstDayOfWeek", obj.getFirstDayOfWeek());
            xml.setAttribute("minimalDaysInFirstWeek", obj.getMinimalDaysInFirstWeek());
            xml.setAttribute("tz", this.getTimeZone(obj).getID());
        }

        private TimeZone getTimeZone(Calendar obj) throws XMLStreamException {
            try {
                return (TimeZone)this._zoneField.get(obj);
            }
            catch (Exception e) {
                throw new XMLStreamException((Throwable)e);
            }
        }
    }

    public static class XMLCurrencyFormat
    extends XMLFormat<Currency> {
        public XMLCurrencyFormat() {
            super(Currency.class);
        }

        public boolean isReferenceable() {
            return false;
        }

        public Currency newInstance(Class<Currency> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return Currency.getInstance(xml.getAttribute("code", ""));
        }

        public void write(Currency currency, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("code", currency.getCurrencyCode());
        }

        public void read(XMLFormat.InputElement xml, Currency pos) {
        }
    }

    public static class XMLMapFormat
    extends XMLFormat<Map<Object, Object>> {
        private final boolean _copyForWrite;

        protected XMLMapFormat(boolean copyForWrite) {
            super(null);
            this._copyForWrite = copyForWrite;
        }

        public Map<Object, Object> newInstance(Class<Map<Object, Object>> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            Map result = (Map)ReflectionBinding.newInstanceFromPublicConstructor(cls, xml);
            if (result == null && Modifier.isPrivate(cls.getModifiers())) {
                try {
                    Constructor<?> constructor = REFLECTION_FACTORY.newConstructorForSerialization(cls, Object.class.getDeclaredConstructor(new Class[0]));
                    constructor.setAccessible(true);
                    result = (Map)constructor.newInstance(INITARGS);
                }
                catch (Exception e) {
                    throw new XMLStreamException((Throwable)e);
                }
            }
            if (result == null) {
                result = (Map)super.newInstance(cls, xml);
            }
            return result;
        }

        public void read(XMLFormat.InputElement xml, Map<Object, Object> obj) throws XMLStreamException {
            while (xml.hasNext()) {
                obj.put(xml.get("k"), xml.get("v"));
            }
        }

        public void write(Map<Object, Object> obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(ReflectionBinding.SIZE, obj.size());
            Set<Map.Entry<Object, Object>> entrySet = this._copyForWrite ? new LinkedHashMap<Object, Object>(obj).entrySet() : obj.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                xml.add(entry.getKey(), "k");
                xml.add(entry.getValue(), "v");
            }
        }
    }

    public static class XMLCollectionFormat
    extends XMLFormat<Collection<Object>> {
        private final boolean _copyForWrite;

        protected XMLCollectionFormat(boolean copyForWrite) {
            super(null);
            this._copyForWrite = copyForWrite;
        }

        public Collection<Object> newInstance(Class<Collection<Object>> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            Collection result = (Collection)ReflectionBinding.newInstanceFromPublicConstructor(cls, xml);
            if (result == null && Modifier.isPrivate(cls.getModifiers())) {
                try {
                    Constructor<?> constructor = REFLECTION_FACTORY.newConstructorForSerialization(cls, Object.class.getDeclaredConstructor(new Class[0]));
                    constructor.setAccessible(true);
                    return (Collection)constructor.newInstance(INITARGS);
                }
                catch (Exception e) {
                    throw new XMLStreamException((Throwable)e);
                }
            }
            if (result == null) {
                result = (Collection)super.newInstance(cls, xml);
            }
            return result;
        }

        public void read(XMLFormat.InputElement xml, Collection<Object> obj) throws XMLStreamException {
            while (xml.hasNext()) {
                obj.add(xml.getNext());
            }
        }

        public void write(Collection<Object> obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(ReflectionBinding.SIZE, obj.size());
            for (Object item : this._copyForWrite ? new ArrayList(obj) : obj) {
                xml.add(item);
            }
        }
    }

    public static class XMLArrayFormat
    extends XMLFormat<Object[]> {
        private final ClassLoader _classLoader;

        public XMLArrayFormat(ClassLoader classLoader) {
            super(null);
            this._classLoader = classLoader;
        }

        public Object[] newInstance(Class clazz, XMLFormat.InputElement input) throws XMLStreamException {
            try {
                String componentType = input.getAttribute("componentType", (String)null);
                int length = input.getAttribute("length", 0);
                return (Object[])Array.newInstance(Class.forName(componentType, false, this._classLoader), length);
            }
            catch (Exception e) {
                LOG.error((Object)"caught exception", (Throwable)e);
                throw new XMLStreamException((Throwable)e);
            }
        }

        public void read(XMLFormat.InputElement input, Object[] array) throws XMLStreamException {
            int i = 0;
            while (input.hasNext()) {
                array[i++] = input.getNext();
            }
        }

        public final void write(Object[] array, XMLFormat.OutputElement output) throws XMLStreamException {
            output.setAttribute("type", "array");
            output.setAttribute("componentType", array.getClass().getComponentType().getName());
            output.setAttribute("length", array.length);
            this.writeElements(array, output);
        }

        public void writeElements(Object[] array, XMLFormat.OutputElement output) throws XMLStreamException {
            for (Object item : array) {
                output.add(item);
            }
        }
    }

    static class XMLEnumFormat
    extends XMLFormat<Enum<?>> {
        private final ClassLoader _classLoader;

        public XMLEnumFormat(ClassLoader classLoader) {
            super(null);
            this._classLoader = classLoader;
        }

        public Enum<?> newInstance(Class<Enum<?>> clazz, XMLFormat.InputElement xml) throws XMLStreamException {
            String value = xml.getAttribute("value").toString();
            String clazzName = xml.getAttribute("type").toString();
            try {
                Enum enumValue = Enum.valueOf(Class.forName(clazzName, true, this._classLoader).asSubclass(Enum.class), value);
                return enumValue;
            }
            catch (ClassNotFoundException e) {
                throw new XMLStreamException((Throwable)e);
            }
        }

        public void read(XMLFormat.InputElement xml, Enum<?> object) throws XMLStreamException {
        }

        public void write(Enum<?> object, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", object.name());
            xml.setAttribute("type", object.getClass().getName());
        }
    }
}

