/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.javolution;

import de.javakaffee.web.msm.serializer.javolution.CustomXMLFormat;
import de.javakaffee.web.msm.serializer.javolution.ReflectionBinding;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;

public class CGLibProxyFormat
extends CustomXMLFormat<Object> {
    private static String DEFAULT_NAMING_MARKER = "$$EnhancerByCGLIB$$";
    private static final String CALLBACKS = "callbacks";
    private static final String INTERFACES = "interfaces";
    private static final String SUPERCLASS = "superclass";

    @Override
    public boolean canConvert(Class<?> cls) {
        return this.canSerialize(cls) || this.canDeserialize(cls);
    }

    private boolean canDeserialize(Class<?> cls) {
        return cls == CGLibProxyMarker.class;
    }

    private boolean canSerialize(Class<?> cls) {
        return Enhancer.isEnhanced(cls) && cls.getName().indexOf(DEFAULT_NAMING_MARKER) > 0;
    }

    @Override
    public Class<?> getTargetClass(Class<?> cls) {
        return CGLibProxyMarker.class;
    }

    public boolean isReferenceable() {
        return false;
    }

    public Object newInstance(Class<Object> cls, XMLFormat.InputElement xml) throws XMLStreamException {
        Class<?> superclass;
        try {
            superclass = Class.forName(xml.getAttribute(SUPERCLASS).toString());
        }
        catch (ClassNotFoundException e) {
            throw new XMLStreamException((Throwable)e);
        }
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Class<?>[] interfaces = ReflectionBinding.XMLJdkProxyFormat.getInterfaces(xml, INTERFACES, classLoader);
        Callback[] callbacks = (Callback[])xml.get(CALLBACKS);
        return this.createProxy(superclass, interfaces, callbacks);
    }

    private Object createProxy(Class<?> targetClass, Class<?>[] interfaces, Callback[] callbacks) {
        Enhancer e = new Enhancer();
        e.setInterfaces((Class[])interfaces);
        e.setSuperclass(targetClass);
        e.setCallbacks(callbacks);
        return e.create();
    }

    public void read(XMLFormat.InputElement arg0, Object arg1) throws XMLStreamException {
    }

    public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
        Class<?> superclass = obj.getClass().getSuperclass();
        xml.setAttribute(SUPERCLASS, superclass.getName());
        String[] interfaceNames = ReflectionBinding.XMLJdkProxyFormat.getInterfaceNames(obj);
        xml.add((Object)interfaceNames, INTERFACES);
        Callback[] callbacks = ((Factory)obj).getCallbacks();
        xml.add((Object)callbacks, CALLBACKS);
    }

    public static interface CGLibProxyMarker {
    }
}

