/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallYarnExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.LernaExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import java.io.File;

final class InstallLernaExecutorConfig
implements LernaExecutorConfig {
    private static final String LERNA_WINDOWS = "/node/lerna".concat("lerna.cmd").replaceAll("/", "\\\\");
    private static final String LERNA_DEFAULT = "/node/lernalerna";
    private File nodePath;
    private final InstallConfig installConfig;

    public InstallLernaExecutorConfig(InstallConfig installConfig) {
        this.installConfig = installConfig;
        this.nodePath = new InstallNodeExecutorConfig(installConfig).getNodePath();
    }

    @Override
    public File getNodePath() {
        return this.nodePath;
    }

    @Override
    public File getYarnPath() {
        String yarnExecutable = this.getPlatform().isWindows() ? InstallYarnExecutorConfig.YARN_WINDOWS : "/node/yarn/dist/bin/yarn";
        return new File(this.installConfig.getInstallDirectory() + yarnExecutable);
    }

    @Override
    public File getLernaPath() {
        String lernaExecutable = this.getPlatform().isWindows() ? LERNA_WINDOWS : LERNA_DEFAULT;
        return new File(this.installConfig.getInstallDirectory() + "/node_modules/.bin/" + lernaExecutable);
    }

    @Override
    public File getWorkingDirectory() {
        return this.installConfig.getWorkingDirectory();
    }

    @Override
    public Platform getPlatform() {
        return this.installConfig.getPlatform();
    }

    @Override
    public String getLernaLocalInstallDirectoryPath() {
        return this.installConfig.getInstallDirectory() + "/node_modules/.bin";
    }

    @Override
    public String getLernaLocalInstallDirectoryPathAlt() {
        return this.installConfig.getWorkingDirectory() + "/node_modules/.bin";
    }
}

