/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.LernaExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.LernaRunner;
import com.github.eirslett.maven.plugins.frontend.lib.LernaTaskExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import java.util.ArrayList;
import java.util.List;

final class DefaultLernaRunner
extends LernaTaskExecutor
implements LernaRunner {
    private static final String TASK_NAME = "lerna";

    public DefaultLernaRunner(LernaExecutorConfig config, ProxyConfig proxyConfig, String npmRegistryURL) {
        super(config, TASK_NAME, config.getLernaPath().getAbsolutePath(), DefaultLernaRunner.buildArguments(proxyConfig, npmRegistryURL));
    }

    private static List<String> buildArguments(ProxyConfig proxyConfig, String npmRegistryURL) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (npmRegistryURL != null && !npmRegistryURL.isEmpty()) {
            arguments.add("--registry=" + npmRegistryURL);
        }
        if (!proxyConfig.isEmpty()) {
            ProxyConfig.Proxy proxy = null;
            if (npmRegistryURL != null && !npmRegistryURL.isEmpty()) {
                proxy = proxyConfig.getProxyForUrl(npmRegistryURL);
            }
            if (proxy == null) {
                proxy = proxyConfig.getSecureProxy();
            }
            if (proxy == null) {
                proxy = proxyConfig.getInsecureProxy();
            }
            arguments.add("--https-proxy=" + proxy.getUri().toString());
            arguments.add("--proxy=" + proxy.getUri().toString());
        }
        return arguments;
    }
}

