/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.tools.kernel;

import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.URLLocator;
import de.intarsys.tools.system.SystemTools;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class PDFFileTools {
    protected static ILocator getRoot(ILocator iLocator) {
        ILocator iLocator2 = iLocator;
        while (iLocator2.getParent() != null) {
            iLocator2 = iLocator2.getParent();
        }
        return iLocator2;
    }

    public static ILocator resolveLocator(String string, ILocator iLocator) throws IOException {
        if (string.contains("://")) {
            return new URLLocator(new URL(string));
        }
        String string2 = PDFFileTools.toOSPath(string);
        if (iLocator == null) {
            return LocatorFactory.get().createLocator(string2);
        }
        if (string2.startsWith("\\") && !string2.startsWith("\\\\")) {
            return PDFFileTools.getRoot(iLocator).getChild(string2);
        }
        File file = new File(string2);
        if (file.isAbsolute()) {
            return LocatorFactory.get().createLocator(string2);
        }
        return iLocator.getChild(string2);
    }

    public static String toOSIndependentPath(String string) {
        if (SystemTools.isWindows()) {
            return PDFFileTools.windowsToOSIndependentPath(string);
        }
        return string;
    }

    public static String toOSPath(String string) {
        if (SystemTools.isWindows()) {
            return PDFFileTools.toWindowsPath(string);
        }
        return string;
    }

    protected static String toWindowsPath(String string) {
        if (File.separatorChar == '/') {
            return string;
        }
        if (string.startsWith("///")) {
            return "\\\\" + string.substring(3).replace("/", "\\");
        }
        if (string.startsWith("//")) {
            return "\\" + string.substring(2).replace("/", "\\");
        }
        if (string.startsWith("/")) {
            File file;
            String string2 = string.substring(1).replace("/", "\\");
            int n = string2.indexOf("\\");
            if (n < 0) {
                n = string2.length();
            }
            string2 = (file = new File(String.valueOf(string2.substring(0, n)) + ":")).isDirectory() ? String.valueOf(string2.substring(0, n)) + ":" + string2.substring(n) : "\\\\" + string2;
            return string2;
        }
        return string.replace("/", "\\");
    }

    protected static String windowsToOSIndependentPath(String string) {
        String string2 = string.replaceAll("\\\\", "/");
        int n = string2.indexOf(":");
        if (n >= 0 && n < string2.indexOf("/")) {
            string2 = "/" + string2.substring(0, n) + string2.substring(n + 1);
        }
        return string2;
    }
}

