/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.system;

public class SystemTools {
    private static final String Bindir;
    private static final String Basedir;
    private static final String Libdir;
    private static final String osName;
    private static final String osArch;
    private static boolean citrix;
    private static boolean windows;
    private static boolean windowsxp;
    private static boolean linux;
    private static boolean mac;

    static {
        citrix = false;
        windows = false;
        windowsxp = false;
        linux = false;
        mac = false;
        String tempName = System.getProperty("de.intarsys.platform.os.name");
        String tempArch = System.getProperty("de.intarsys.platform.os.arch", "x86");
        if (tempName == null) {
            tempName = System.getProperty("os.name");
            tempArch = System.getProperty("os.arch");
        }
        osName = tempName;
        osArch = tempArch;
        String osNameLowerCase = osName.toLowerCase();
        if (osNameLowerCase.startsWith("win")) {
            windows = true;
            if (osNameLowerCase.equals("windows xp")) {
                windowsxp = true;
            }
            Libdir = "bin";
            Bindir = "bin";
            Basedir = "";
        } else if (osNameLowerCase.startsWith("linux")) {
            linux = true;
            if ("amd64".equals(osArch)) {
                Bindir = "bin";
                Libdir = "lib/amd64";
            } else {
                Bindir = "bin";
                Libdir = "lib/i386";
            }
            Basedir = "";
        } else if (osNameLowerCase.startsWith("mac")) {
            mac = true;
            Libdir = "MacOS";
            Bindir = "MacOS";
            Basedir = "Resources";
        } else {
            Basedir = "";
            Libdir = "";
            Bindir = "";
        }
        citrix = Boolean.getBoolean("de.intarsys.platform.citrix");
    }

    public static String getBasedir() {
        return Basedir;
    }

    public static String getBindir() {
        return Bindir;
    }

    public static String getLibdir() {
        return Libdir;
    }

    public static String getOSArch() {
        return osArch;
    }

    public static String getOSName() {
        return osName;
    }

    public static boolean isCitrix() {
        return citrix;
    }

    public static boolean isLinux() {
        return linux;
    }

    public static boolean isMac() {
        return mac;
    }

    public static boolean isWindows() {
        return windows;
    }

    public static boolean isWindowsXP() {
        return windowsxp;
    }

    private SystemTools() {
    }
}

