/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences;

import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.string.CharacterTools;
import de.intarsys.tools.string.Converter;
import de.intarsys.tools.string.ConverterException;
import java.awt.Rectangle;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesTools {
    public static final String ELEMENT_SEPARATOR = ";";
    public static final String KEY_VALUE_SEPARATOR = "=";

    public static String fitKey(String name) {
        int length = name.length();
        if (length <= 80) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = new char[length];
        name.getChars(0, length, chars, 0);
        boolean start = true;
        int i = 0;
        while (i < length) {
            char c = chars[i];
            if (c == '.' || c == '/' || c == '\\' || c == '_') {
                start = true;
            } else if (Character.isUpperCase(c) || c == '.') {
                start = true;
                sb.append(c);
            } else if (CharacterTools.isVowel(c)) {
                if (start) {
                    start = false;
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        name = sb.toString();
        length = name.length();
        if (length <= 80) {
            return name;
        }
        return name.substring(length - 80, length);
    }

    public static <T extends EnumItem> T getEnumItem(IPreferences preferences, EnumMeta<T> meta, String name) {
        if (preferences == null) {
            return meta.getDefault();
        }
        String optionValue = preferences.get(name);
        return meta.getItemOrDefault(optionValue);
    }

    public static <T extends EnumItem> T getEnumItem(IPreferences preferences, EnumMeta<T> meta, String name, String defaultValue) {
        if (preferences == null) {
            return meta.getItemOrDefault(defaultValue);
        }
        String optionValue = preferences.get(name, defaultValue);
        return meta.getItemOrDefault(optionValue);
    }

    public static String getLarge(IPreferences preferences, String key, String defaultValue) {
        String subKey;
        String subValue;
        if (preferences == null) {
            return null;
        }
        IPreferences childNode = preferences.node(key);
        int i = 0;
        if ((subValue = childNode.get(subKey = "part" + i++, null)) == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (subValue != null && subValue.length() == 8192) {
            sb.append(subValue);
            subKey = "part" + i++;
            subValue = childNode.get(subKey, null);
        }
        if (subValue != null) {
            sb.append(subValue);
        }
        return sb.toString();
    }

    public static void importPreferences(IPreferences root, IPreferences source) throws BackingStoreException {
        String[] childrenNames = source.childrenNames();
        int i = 0;
        while (i < childrenNames.length) {
            String childName = childrenNames[i];
            IPreferences rootChild = root.node(childName);
            IPreferences sourceChild = source.node(childName);
            PreferencesTools.importPreferences(rootChild, sourceChild);
            ++i;
        }
        String[] keys = source.keys();
        int i2 = 0;
        while (i2 < keys.length) {
            String key = keys[i2];
            root.put(key, source.get(key));
            ++i2;
        }
    }

    public static void putEnumItem(IPreferences preferences, String name, EnumItem item) {
        preferences.put(name, item.getId());
    }

    public static void putLarge(IPreferences preferences, String key, String longValue) {
        try {
            String subKey;
            preferences.remove(key);
            IPreferences childNode = preferences.node(key);
            childNode.clear();
            StringReader reader = new StringReader(longValue);
            char[] buffer = new char[8192];
            int i = 0;
            String subValue = null;
            int length = reader.read(buffer);
            while (length != -1) {
                subKey = "part" + i++;
                subValue = new String(buffer, 0, length);
                childNode.put(subKey, subValue);
                length = reader.read(buffer);
            }
            if (subValue != null && subValue.length() == 8192) {
                subKey = "part" + i++;
                subValue = "";
                childNode.put(subKey, subValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Rectangle toRect(String value) {
        if (value == null) {
            return null;
        }
        int[] rectDef = Converter.asIntArray(value);
        if (rectDef == null || rectDef.length < 4) {
            return null;
        }
        return new Rectangle(rectDef[0], rectDef[1], rectDef[2], rectDef[3]);
    }

    public static Rectangle toRect(String value, int[] ranges) {
        if (value == null) {
            return null;
        }
        String[] rectDefs = Converter.asStringArray(value);
        if (rectDefs == null || rectDefs.length != 4) {
            return null;
        }
        int[] rectValues = new int[4];
        int i = 0;
        while (i < rectDefs.length) {
            String rectDef = rectDefs[i];
            if (rectDef.indexOf("%") >= 0) {
                rectDef = rectDef.replaceAll("%", "");
                try {
                    rectValues[i] = (int)((float)Converter.asInteger(rectDef) * (float)ranges[i] / 100.0f);
                }
                catch (ConverterException e) {
                    rectValues[i] = 0;
                }
            } else {
                try {
                    rectValues[i] = Converter.asInteger(rectDef);
                }
                catch (ConverterException e) {
                    rectValues[i] = 0;
                }
            }
            ++i;
        }
        return new Rectangle(rectValues[0], rectValues[1], rectValues[2], rectValues[3]);
    }

    public static String toString(float[] value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (value != null) {
            int i = 0;
            while (i < value.length) {
                if (i != 0) {
                    sb.append(ELEMENT_SEPARATOR);
                }
                sb.append(value[i]);
                ++i;
            }
        }
        return sb.toString();
    }

    public static String toString(int[] value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length) {
            if (i != 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append(value[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String toString(List value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = value.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            sb.append(String.valueOf(element));
            if (!it.hasNext()) continue;
            sb.append(ELEMENT_SEPARATOR);
        }
        return sb.toString();
    }

    public static String toString(Map map) {
        if (map == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            sb.append(String.valueOf(entry.getKey()));
            sb.append(KEY_VALUE_SEPARATOR);
            String value = entry.getValue() == null ? "" : String.valueOf(entry.getValue());
            sb.append((Object)value);
            if (!i.hasNext()) continue;
            sb.append(ELEMENT_SEPARATOR);
        }
        return sb.toString();
    }

    public static String toString(Rectangle rect) {
        if (rect == null) {
            return "";
        }
        int[] rectDef = new int[]{rect.x, rect.y, rect.width, rect.height};
        return PreferencesTools.toString(rectDef);
    }

    public static String toString(String[] value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length) {
            if (i != 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append(value[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String[] toStringArray(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer tk = new StringTokenizer(value, ELEMENT_SEPARATOR, false);
        String[] result = new String[tk.countTokens()];
        int i = 0;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            result[i] = token.trim();
            ++i;
        }
        return result;
    }

    private PreferencesTools() {
    }
}

