/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MagicFileNumberTest {
    private static Map types = new HashMap();

    static {
        MagicFileNumberTest.addTypes();
    }

    public static void addType(String fileSuffix, byte[] magicBytes) {
        if (fileSuffix == null || magicBytes == null || magicBytes.length == 0) {
            return;
        }
        Type type = new Type(fileSuffix, magicBytes);
        if (!types.containsKey(type.getKey())) {
            types.put(type.getKey(), type);
        }
    }

    protected static void addTypes() {
        MagicFileNumberTest.addType("bmp", new byte[]{66, 77});
        MagicFileNumberTest.addType("fits", new byte[]{83, 73, 77, 80, 76, 69});
        MagicFileNumberTest.addType("gif", new byte[]{71, 73, 70, 56});
        MagicFileNumberTest.addType("gks", new byte[]{71, 75, 83, 77});
        MagicFileNumberTest.addType("rgb", new byte[]{1, -38});
        byte[] byArray = new byte[4];
        byArray[0] = -15;
        byArray[2] = 64;
        byArray[3] = -69;
        MagicFileNumberTest.addType("itc", byArray);
        MagicFileNumberTest.addType("jpg", new byte[]{-1, -40, -1});
        MagicFileNumberTest.addType("nif", new byte[]{73, 73, 78, 49});
        MagicFileNumberTest.addType("pm", new byte[]{86, 73, 69, 87});
        MagicFileNumberTest.addType("png", new byte[]{-119, 80, 78, 71});
        MagicFileNumberTest.addType("ps", new byte[]{37, 33});
        MagicFileNumberTest.addType("ras", new byte[]{89, -90, 106, -107});
        byte[] byArray2 = new byte[4];
        byArray2[0] = 77;
        byArray2[1] = 77;
        byArray2[3] = 42;
        MagicFileNumberTest.addType("tif", byArray2);
        byte[] byArray3 = new byte[4];
        byArray3[0] = 73;
        byArray3[1] = 73;
        byArray3[2] = 42;
        MagicFileNumberTest.addType("tif", byArray3);
        MagicFileNumberTest.addType("xcf", new byte[]{103, 105, 109, 112, 32, 120, 99, 102, 32, 118});
        MagicFileNumberTest.addType("fig", new byte[]{35, 70, 73, 71});
        MagicFileNumberTest.addType("xpm", new byte[]{47, 42, 32, 88, 80, 77, 32, 42, 47});
        MagicFileNumberTest.addType("bz", new byte[]{66, 90});
        MagicFileNumberTest.addType("Z", new byte[]{31, -99});
        MagicFileNumberTest.addType("gz", new byte[]{31, -117});
        MagicFileNumberTest.addType("zip", new byte[]{80, 75, 3, 4});
        MagicFileNumberTest.addType("tar", new byte[]{117, 115, 116, 97, 114});
        MagicFileNumberTest.addType("exe", new byte[]{77, 90});
        MagicFileNumberTest.addType("unix elf", new byte[]{127, 69, 76, 70});
        byte[] byArray4 = new byte[2];
        byArray4[0] = -103;
        MagicFileNumberTest.addType("pgp public ring", byArray4);
        MagicFileNumberTest.addType("pgp security ring", new byte[]{-107, 1});
        byte[] byArray5 = new byte[2];
        byArray5[0] = -107;
        MagicFileNumberTest.addType("pgp security ring", byArray5);
        byte[] byArray6 = new byte[2];
        byArray6[0] = -90;
        MagicFileNumberTest.addType("pgp encrypted data", byArray6);
        try {
            MagicFileNumberTest.addType("pdf", "%PDF".getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static String guessFileSuffix(byte[] data) {
        String string;
        if (data == null) {
            return null;
        }
        RandomAccessByteArray ra = null;
        try {
            ra = new RandomAccessByteArray(data);
            string = MagicFileNumberTest.guessFileSuffix(ra);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                StreamTools.close(ra);
                throw throwable;
            }
        }
        StreamTools.close(ra);
        return string;
    }

    public static String guessFileSuffix(IRandomAccess data) throws IOException {
        Iterator i = types.entrySet().iterator();
        while (i.hasNext()) {
            Type type = (Type)i.next().getValue();
            if (!type.matches(data)) continue;
            return type.getSuffix();
        }
        return null;
    }

    public static boolean isText(byte[] data) {
        boolean bl;
        RandomAccessByteArray ra = null;
        try {
            ra = new RandomAccessByteArray(data);
            bl = MagicFileNumberTest.isText(ra);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                StreamTools.close(ra);
                throw throwable;
            }
        }
        StreamTools.close(ra);
        return bl;
    }

    public static boolean isText(IRandomAccess data) throws IOException {
        if (data == null) {
            return false;
        }
        data.reset();
        int i = 0;
        int c = data.read();
        while (c != -1 && i < 1024) {
            if (((c &= 0xFF) < 32 || c > 126) && c < 160) {
                switch (c) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            c = data.read();
            ++i;
        }
        return true;
    }

    private MagicFileNumberTest() {
    }

    public static class Type {
        private String suffix;
        private byte[] magicBytes;

        public Type(String suffix, byte[] magic) {
            this.suffix = suffix;
            this.magicBytes = magic;
        }

        public String getKey() {
            return HexTools.bytesToHexString(this.magicBytes);
        }

        public byte[] getMagicBytes() {
            return this.magicBytes;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public boolean matches(IRandomAccess data) throws IOException {
            data.reset();
            int i = 0;
            while (i < this.magicBytes.length) {
                if (this.magicBytes[i] != data.read()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public String toString() {
            return this.suffix;
        }
    }
}

