/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.Expression;
import com.inet.lib.less.Formattable;
import com.inet.lib.less.HashMultimap;
import com.inet.lib.less.LessException;
import com.inet.lib.less.LessObject;
import com.inet.lib.less.MixinMatch;
import com.inet.lib.less.Operation;
import com.inet.lib.less.Rule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

class Mixin
extends LessObject
implements Formattable {
    private final String name;
    private final HashMultimap<String, Rule> mixins;
    private final List<Expression> paramValues;
    private final boolean important;
    private List<MixinMatch> mixinRules;
    private int stackID;

    Mixin(LessObject obj, String name, Operation paramValues, HashMultimap<String, Rule> mixins) {
        super(obj);
        if (name.endsWith("important")) {
            boolean importantTemp = false;
            block4: for (int i = name.length() - 10; i >= 0; --i) {
                switch (name.charAt(i)) {
                    case ' ': {
                        continue block4;
                    }
                    case '!': {
                        importantTemp = true;
                        name = name.substring(0, i).trim();
                        break block4;
                    }
                }
            }
            this.important = importantTemp;
        } else {
            this.important = false;
        }
        this.name = name;
        this.paramValues = paramValues == null ? null : paramValues.getOperands();
        this.mixins = mixins;
    }

    @Override
    public final int getType() {
        return 2;
    }

    @Override
    public void appendTo(CssFormatter formatter) {
        try {
            if (this.important) {
                formatter.incImportant();
            }
            for (MixinMatch match : this.getRules(formatter)) {
                Rule rule = match.getRule();
                formatter.addMixin(rule, match.getMixinParameters(), rule.getVariables());
                rule.appendPropertiesTo(formatter);
                formatter.removeMixin();
            }
        }
        catch (LessException ex) {
            ex.addPosition(this.filename, this.line, this.column);
            throw ex;
        }
        catch (StackOverflowError soe) {
            throw this.createException("Maximum call stack size exceeded in mixin: " + this.name, soe);
        }
        finally {
            if (this.important) {
                formatter.decImportant();
            }
        }
    }

    void appendSubRules(String[] parentSelector, CssFormatter formatter) {
        try {
            if (this.important) {
                formatter.incImportant();
            }
            for (MixinMatch match : this.getRules(formatter)) {
                Rule rule = match.getRule();
                formatter.addMixin(rule, match.getMixinParameters(), rule.getVariables());
                rule.appendMixinsTo(parentSelector, formatter);
                for (Rule subMixin : rule.getSubrules()) {
                    if (subMixin.isMixin() || parentSelector != null && subMixin.isInlineRule(formatter)) continue;
                    subMixin.appendTo(parentSelector, formatter);
                }
                formatter.removeMixin();
            }
        }
        catch (LessException ex) {
            ex.addPosition(this.filename, this.line, this.column);
            throw ex;
        }
        finally {
            if (this.important) {
                formatter.decImportant();
            }
        }
    }

    @Nonnull
    private List<MixinMatch> getRules(CssFormatter formatter) throws LessException {
        MixinMatch matching;
        if (this.mixinRules != null && this.stackID == formatter.stackID()) {
            return this.mixinRules;
        }
        List<Rule> rules = formatter.getMixin(this.name);
        if (rules == null) {
            rules = this.mixins.get(this.name);
        }
        if (rules == null) {
            String mainName;
            int idx = this.name.indexOf(62);
            if (idx > 0) {
                mainName = this.name.substring(0, idx).trim();
                rules = this.mixins.get(mainName);
                if (rules != null) {
                    rules = rules.get(0).getMixin(this.name.substring(idx + 1).trim());
                }
            } else {
                idx = this.name.indexOf(46);
                if (idx > 0 && (rules = this.mixins.get(mainName = this.name.substring(0, idx).trim())) != null) {
                    rules = rules.get(0).getMixin(this.name.substring(idx).trim());
                }
            }
            if (rules == null) {
                throw this.createException("Undefine mixin: " + this.name);
            }
        }
        this.stackID = formatter.stackID();
        this.mixinRules = new ArrayList<MixinMatch>();
        boolean paramMatch = false;
        ArrayList<Rule> defaultMixins = null;
        for (Rule rule : rules) {
            matching = rule.match(formatter, this.paramValues, false);
            if (matching == null) continue;
            paramMatch = true;
            if (matching.getGuard()) {
                this.mixinRules.add(matching);
                continue;
            }
            if (!matching.wasDefault()) continue;
            if (defaultMixins == null) {
                defaultMixins = new ArrayList<Rule>();
            }
            defaultMixins.add(rule);
        }
        if (!paramMatch) {
            throw this.createException("No matching definition was found for: " + this.name);
        }
        if (this.mixinRules.size() == 0 && defaultMixins != null) {
            for (Rule rule : defaultMixins) {
                matching = rule.match(formatter, this.paramValues, true);
                if (matching == null || !matching.getGuard()) continue;
                this.mixinRules.add(matching);
            }
        }
        return this.mixinRules;
    }
}

