/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.CompressCssFormatter;
import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.LessException;
import com.inet.lib.less.LessParser;
import com.inet.lib.less.ReaderFactory;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public class Less {
    public static String compile(URL baseURL, String lessData, boolean compress) throws LessException {
        return Less.compile(baseURL, lessData, compress, new ReaderFactory());
    }

    public static String compile(URL baseURL, String lessData, boolean compress, ReaderFactory readerFactory) throws LessException {
        try {
            LessParser parser = new LessParser();
            parser.parse(baseURL, new StringReader(lessData), readerFactory);
            StringBuilder builder = new StringBuilder();
            CssFormatter formatter = compress ? new CompressCssFormatter() : new CssFormatter();
            parser.parseLazy(formatter);
            formatter.format(parser, baseURL, builder);
            return builder.toString();
        }
        catch (LessException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new LessException(ex);
        }
    }

    public static String compile(File lessFile, boolean compress) throws IOException {
        String lessData = new String(Files.readAllBytes(lessFile.toPath()), StandardCharsets.UTF_8);
        return Less.compile(lessFile.toURI().toURL(), lessData, compress, new ReaderFactory());
    }

    public static String compile(File lessFile, boolean compress, ReaderFactory readerFactory) throws IOException {
        String lessData = new String(Files.readAllBytes(lessFile.toPath()), StandardCharsets.UTF_8);
        return Less.compile(lessFile.toURI().toURL(), lessData, compress, readerFactory);
    }
}

