/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.Expression;
import com.inet.lib.less.HSL;
import com.inet.lib.less.HSV;

class ColorUtils {
    private static final int MULTIPLY = 0;
    private static final int SCREEN = 1;
    private static final int OVERLAY = 2;
    private static final int SOFTLIGHT = 3;
    private static final int HARDLIGHT = 4;
    private static final int DIFFERENCE = 5;
    private static final int EXCLUSION = 6;
    private static final int AVERAGE = 7;
    private static final int NEGATION = 8;
    private static final int[][] HSVA_PERM = new int[][]{{0, 3, 1}, {2, 0, 1}, {1, 0, 3}, {1, 2, 0}, {3, 1, 0}, {0, 1, 2}};

    ColorUtils() {
    }

    static HSL toHSL(double color) {
        double h;
        double s;
        long argb = Double.doubleToRawLongBits(color);
        double a = ColorUtils.alpha(color);
        double r = ColorUtils.clamp((double)(argb >> 32 & 0xFFFFL) / 65280.0);
        double g = ColorUtils.clamp((double)(argb >> 16 & 0xFFFFL) / 65280.0);
        double b = ColorUtils.clamp((double)(argb >> 0 & 0xFFFFL) / 65280.0);
        double max = Math.max(Math.max(r, g), b);
        double min = Math.min(Math.min(r, g), b);
        double l = (max + min) / 2.0;
        double d = max - min;
        if (max == min) {
            s = 0.0;
            h = 0.0;
        } else {
            double d2 = s = l > 0.5 ? d / (2.0 - max - min) : d / (max + min);
            h = max == r ? (g - b) / d + (double)(g < b ? 6 : 0) : (max == g ? (b - r) / d + 2.0 : (r - g) / d + 4.0);
            h /= 6.0;
        }
        return new HSL(h * 360.0, s, l, a);
    }

    static double clamp(double val) {
        return Math.min(1.0, Math.max(0.0, val));
    }

    static double rgba(double r, double g, double b, double a) {
        return Double.longBitsToDouble(Math.round(a * 65535.0) << 48 | ColorUtils.colorLargeDigit(r) << 32 | ColorUtils.colorLargeDigit(g) << 16 | ColorUtils.colorLargeDigit(b));
    }

    static double rgba(int r, int g, int b, double a) {
        return Double.longBitsToDouble(Math.round(a * 65535.0) << 48 | ColorUtils.colorLargeDigit(r) << 32 | ColorUtils.colorLargeDigit(g) << 16 | ColorUtils.colorLargeDigit(b));
    }

    static double rgb(int r, int g, int b) {
        return Double.longBitsToDouble(0xFFFF000000000000L | ColorUtils.colorLargeDigit(r) << 32 | ColorUtils.colorLargeDigit(g) << 16 | ColorUtils.colorLargeDigit(b));
    }

    static int argb(double color) {
        long value = Double.doubleToRawLongBits(color);
        int result = ColorUtils.colorDigit((double)(value >>> 48) / 256.0) << 24;
        result |= ColorUtils.colorDigit((double)(value >> 32 & 0xFFFFL) / 256.0) << 16;
        result |= ColorUtils.colorDigit((double)(value >> 16 & 0xFFFFL) / 256.0) << 8;
        return result |= ColorUtils.colorDigit((double)(value & 0xFFFFL) / 256.0);
    }

    static double alpha(double color) {
        double value = (double)(Double.doubleToRawLongBits(color) >>> 48) / 65535.0;
        return (double)Math.round(value * 10000.0) / 10000.0;
    }

    static int red(double color) {
        return ColorUtils.colorDigit((double)(Double.doubleToRawLongBits(color) >> 32 & 0xFFFFL) / 256.0);
    }

    static int green(double color) {
        return ColorUtils.colorDigit((double)(Double.doubleToRawLongBits(color) >> 16 & 0xFFFFL) / 256.0);
    }

    static int blue(double color) {
        return ColorUtils.colorDigit((double)(Double.doubleToRawLongBits(color) & 0xFFFFL) / 256.0);
    }

    private static double hslaHue(double h, double m1, double m2) {
        double d = h < 0.0 ? h + 1.0 : (h = h > 1.0 ? h - 1.0 : h);
        if (h * 6.0 < 1.0) {
            return m1 + (m2 - m1) * h * 6.0;
        }
        if (h * 2.0 < 1.0) {
            return m2;
        }
        if (h * 3.0 < 2.0) {
            return m1 + (m2 - m1) * (0.6666666865348816 - h) * 6.0;
        }
        return m1;
    }

    static double hsla(HSL hsl) {
        return ColorUtils.hsla(hsl.h, hsl.s, hsl.l, hsl.a);
    }

    static double hsla(double h, double s, double l, double a) {
        h = h % 360.0 / 360.0;
        s = ColorUtils.clamp(s);
        l = ColorUtils.clamp(l);
        a = ColorUtils.clamp(a);
        double m2 = l <= 0.5 ? l * (s + 1.0) : l + s - l * s;
        double m1 = l * 2.0 - m2;
        return ColorUtils.rgba(ColorUtils.hslaHue(h + 0.3333333333333333, m1, m2) * 255.0, ColorUtils.hslaHue(h, m1, m2) * 255.0, ColorUtils.hslaHue(h - 0.3333333333333333, m1, m2) * 255.0, a);
    }

    static double luminance(double color) {
        long argb = Double.doubleToRawLongBits(color);
        double r = (double)(argb >> 32 & 0xFFFFL) / 65280.0;
        double g = (double)(argb >> 16 & 0xFFFFL) / 65280.0;
        double b = (double)(argb & 0xFFFFL) / 65280.0;
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    }

    static double luma(double color) {
        long argb = Double.doubleToRawLongBits(color);
        double r = (double)(argb >> 32 & 0xFFFFL) / 65280.0;
        double g = (double)(argb >> 16 & 0xFFFFL) / 65280.0;
        double b = (double)(argb & 0xFFFFL) / 65280.0;
        r = r <= 0.03928 ? r / 12.92 : Math.pow((r + 0.055) / 1.055, 2.4);
        g = g <= 0.03928 ? g / 12.92 : Math.pow((g + 0.055) / 1.055, 2.4);
        b = b <= 0.03928 ? b / 12.92 : Math.pow((b + 0.055) / 1.055, 2.4);
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    }

    static double contrast(double color, double dark, double light, double threshold) {
        if (ColorUtils.luma(dark) > ColorUtils.luma(light)) {
            double t = light;
            light = dark;
            dark = t;
        }
        if (ColorUtils.luma(color) < threshold) {
            return light;
        }
        return dark;
    }

    static HSV toHSV(double color) {
        long argb = Double.doubleToRawLongBits(color);
        double a = ColorUtils.alpha(color);
        double r = ColorUtils.clamp((double)(argb >> 32 & 0xFFFFL) / 65280.0);
        double g = ColorUtils.clamp((double)(argb >> 16 & 0xFFFFL) / 65280.0);
        double b = ColorUtils.clamp((double)(argb >> 0 & 0xFFFFL) / 65280.0);
        double max = Math.max(Math.max(r, g), b);
        double min = Math.min(Math.min(r, g), b);
        double v = max;
        double d = max - min;
        double s = max == 0.0 ? 0.0 : d / max;
        double h = max == min ? 0.0 : (max == r ? (g - b) / d + (double)(g < b ? 6 : 0) : (max == g ? (b - r) / d + 2.0 : (r - g) / d + 4.0));
        return new HSV((h /= 6.0) * 360.0, s, v, a);
    }

    static double hsva(double hue, double saturation, double value, double alpha) {
        hue = hue % 360.0 / 360.0 * 360.0;
        int i = (int)Math.floor(hue / 60.0 % 6.0);
        double f = hue / 60.0 - (double)i;
        double[] vs = new double[]{value, value * (1.0 - saturation), value * (1.0 - f * saturation), value * (1.0 - (1.0 - f) * saturation)};
        return ColorUtils.rgba(vs[HSVA_PERM[i][0]] * 255.0, vs[HSVA_PERM[i][1]] * 255.0, vs[HSVA_PERM[i][2]] * 255.0, alpha);
    }

    static double mix(double color1, double color2, double weight) {
        long col1 = Double.doubleToRawLongBits(color1);
        long col2 = Double.doubleToRawLongBits(color2);
        int alpha1 = (int)(col1 >>> 48);
        int red1 = (int)(col1 >> 32) & 0xFFFF;
        int green1 = (int)(col1 >> 16) & 0xFFFF;
        int blue1 = (int)col1 & 0xFFFF;
        int alpha2 = (int)(col2 >>> 48);
        int red2 = (int)(col2 >> 32) & 0xFFFF;
        int green2 = (int)(col2 >> 16) & 0xFFFF;
        int blue2 = (int)col2 & 0xFFFF;
        double w = weight * 2.0 - 1.0;
        double a = (double)(alpha1 - alpha2) / 65535.0;
        double w1 = ((w * a == -1.0 ? w : (w + a) / (1.0 + w * a)) + 1.0) / 2.0;
        double w2 = 1.0 - w1;
        long red = Math.round((double)red1 * w1 + (double)red2 * w2);
        long green = Math.round((double)green1 * w1 + (double)green2 * w2);
        long blue = Math.round((double)blue1 * w1 + (double)blue2 * w2);
        long alpha = Math.round((double)alpha1 * weight + (double)alpha2 * (1.0 - weight));
        long color = alpha << 48 | red << 32 | green << 16 | blue;
        return Double.longBitsToDouble(color);
    }

    static double multiply(double color1, double color2) {
        return ColorUtils.colorBlending(color1, color2, 0);
    }

    static double screen(double color1, double color2) {
        return ColorUtils.colorBlending(color1, color2, 1);
    }

    static double overlay(double color1, double color2) {
        return ColorUtils.colorBlending(color1, color2, 2);
    }

    static double softlight(double color1, double color2) {
        return ColorUtils.colorBlending(color1, color2, 3);
    }

    static double hardlight(double color1, double color2) {
        return ColorUtils.colorBlending(color1, color2, 4);
    }

    static double difference(double color1, double color2) {
        return ColorUtils.colorBlending(color1, color2, 5);
    }

    static double exclusion(double color1, double color2) {
        return ColorUtils.colorBlending(color1, color2, 6);
    }

    static double average(double color1, double color2) {
        return ColorUtils.colorBlending(color1, color2, 7);
    }

    static double negation(double color1, double color2) {
        return ColorUtils.colorBlending(color1, color2, 8);
    }

    private static double colorBlending(double color1, double color2, int op) {
        long argb1 = Double.doubleToRawLongBits(color1);
        long r1 = argb1 >> 32 & 0xFFFFL;
        long g1 = argb1 >> 16 & 0xFFFFL;
        long b1 = argb1 & 0xFFFFL;
        long argb2 = Double.doubleToRawLongBits(color2);
        long r2 = argb2 >> 32 & 0xFFFFL;
        long g2 = argb2 >> 16 & 0xFFFFL;
        long b2 = argb2 & 0xFFFFL;
        r1 = ColorUtils.colorBlendingDigit(r1, r2, op);
        g1 = ColorUtils.colorBlendingDigit(g1, g2, op);
        b1 = ColorUtils.colorBlendingDigit(b1, b2, op);
        argb1 = r1 << 32 | g1 << 16 | b1;
        return Double.longBitsToDouble(argb1);
    }

    private static long colorBlendingDigit(long longDigit1, long longDigit2, int op) {
        switch (op) {
            case 0: {
                return longDigit1 * longDigit2 / 65280L;
            }
            case 1: {
                return longDigit1 + longDigit2 - longDigit1 * longDigit2 / 65280L;
            }
            case 2: {
                if ((longDigit1 *= 2L) <= 65280L) {
                    return ColorUtils.colorBlendingDigit(longDigit1, longDigit2, 0);
                }
                return ColorUtils.colorBlendingDigit(longDigit1 - 65280L, longDigit2, 1);
            }
            case 3: {
                long d = 65280L;
                long e = longDigit1;
                if (longDigit2 > 32768L) {
                    e = 65280L;
                    d = longDigit1 > 16384L ? (long)(Math.sqrt((double)longDigit1 / 65280.0) * 65280.0) : ((16L * longDigit1 - 783360L) * longDigit1 / 65280L + 261120L) * longDigit1 / 65280L;
                }
                return longDigit1 - (65280L - 2L * longDigit2) * e * (d - longDigit1) / 65280L / 65280L;
            }
            case 4: {
                return ColorUtils.colorBlendingDigit(longDigit2, longDigit1, 2);
            }
            case 5: {
                return Math.abs(longDigit1 - longDigit2);
            }
            case 6: {
                return longDigit1 + longDigit2 - 2L * longDigit1 * longDigit2 / 65280L;
            }
            case 7: {
                return (longDigit1 + longDigit2) / 2L;
            }
            case 8: {
                return 65280L - Math.abs(longDigit1 + longDigit2 - 65280L);
            }
        }
        throw new IllegalArgumentException(String.valueOf(op));
    }

    static int colorDigit(double value) {
        if (value >= 255.0) {
            return 255;
        }
        if (value <= 0.0) {
            return 0;
        }
        return (int)Math.round(value);
    }

    private static long colorLargeDigit(double value) {
        if ((value *= 256.0) >= 65535.0) {
            return 65535L;
        }
        if (value <= 0.0) {
            return 0L;
        }
        return Math.round(value);
    }

    static double getPercent(Expression expression, CssFormatter formatter) {
        double d = expression.doubleValue(formatter);
        if (expression.getDataType(formatter) == 3) {
            d /= 100.0;
        } else if (d > 1.0 && d == (double)((int)d)) {
            d /= 100.0;
        }
        return d;
    }
}

