/*
 * Decompiled with CFR 0.152.
 */
package de.hanbei.httpserver.common;

import de.hanbei.httpserver.common.Cookie;
import de.hanbei.httpserver.common.MultiValuedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Header {
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private MultiValuedMap<String, Parameter> fields = new MultiValuedMap();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (!this.fields.isEmpty()) {
            for (String parameterKey : this.fields.keySet()) {
                buffer.append(parameterKey);
                buffer.append(": ");
                List parameterList = (List)this.fields.get(parameterKey);
                String delim = "";
                for (Parameter p : parameterList) {
                    buffer.append(delim).append(p);
                    delim = ",";
                }
                buffer.append("\n");
            }
        }
        if (!this.cookies.isEmpty()) {
            buffer.append("Cookie");
            buffer.append(": ");
            String delim = "";
            for (Cookie cookie : this.cookies) {
                buffer.append(delim).append(cookie.getName()).append("=").append(cookie.getValue());
                delim = "; ";
            }
        }
        return buffer.toString();
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public Set<String> getHeaderFields() {
        return Collections.unmodifiableSet(this.fields.keySet());
    }

    public List<Parameter> getHeaderParameter(String field) {
        List parameters = (List)this.fields.get(field);
        if (parameters == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Parameter>(parameters);
    }

    public List<String> getHeaderValues(String field) {
        List list = (List)this.fields.get(field);
        ArrayList<String> values = new ArrayList<String>();
        for (Parameter p : list) {
            values.add(p.getValue());
        }
        return values;
    }

    public void addParameter(String parameter, String value) {
        this.fields.add(parameter, new Parameter(value));
    }

    public void addParameter(String fieldName, Parameter parameter) {
        this.fields.add(fieldName, parameter);
    }

    public List<Cookie> getCookies() {
        return Collections.unmodifiableList(this.cookies);
    }

    public void setCookies(List<Cookie> cookies) {
        this.cookies = new ArrayList<Cookie>(cookies);
    }

    public void addParameter(String field, String value, double quality) {
        this.fields.add(field, new Parameter(value, quality));
    }

    public static class Parameter {
        private static final double EPSILON = 1.0E-14;
        private String value;
        private double quality;

        public Parameter(String value) {
            this(value, -1.0);
        }

        public Parameter(String value, double quality) {
            this.value = value;
            this.quality = quality;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.quality);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter other = (Parameter)obj;
            if (Double.doubleToLongBits(this.quality) != Double.doubleToLongBits(other.quality)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public double getQuality() {
            return this.quality;
        }

        public void setQuality(double quality) {
            this.quality = quality;
        }

        public String toString() {
            if (Math.abs(this.quality + 1.0) < 1.0E-14) {
                return this.value;
            }
            return this.value + ";q=" + this.quality;
        }
    }

    public static final class Fields {
        public static final String CONNECTION = "Connection";
        public static final String DATE = "Date";
        public static final String PRAGMA = "Pragma";
        public static final String TRANSFER_ENCODING = "Transfer-Encoding";
        public static final String WARNING = "Warning";
        public static final String AGE = "Age";
        public static final String KEEP_ALIVE = "Keep-Alive";
        public static final String COOKIE = "Cookie";
        public static final String ACCEPT_MIMETYPE = "Accept";
        public static final String ACCEPT = "Accept";
        public static final String ACCEPT_LANGUAGE = "Accept-Language";
        public static final String ACCEPT_ENCODING = "Accept-Encoding";
        public static final String ACCEPT_CHARSET = "Accept-Charset";
        public static final String ACCEPT_RANGES = "Accept-Ranges";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String CONTENT_LENGTH = "Content-Length";
        public static final String CONTENT_ENCODING = "Content-Encoding";
        public static final String CONTENT_LANGUAGE = "Content-Language";
        public static final String CONTENT_LOCATION = "Content-Location";
        public static final String CONTENT_RANGE = "Content-Range";
        public static final String CONTENT_MD5 = "Content-MD5";
        public static final String ETAG = "ETag";
        public static final String EXPECT = "Expect";
        public static final String EXPIRES = "Expires";
        public static final String HOST = "Host";
        public static final String LAST_MODIFIED = "Last-Modified";
        public static final String LOCATION = "Location";
        public static final String USER_AGENT = "User-Agent";
        public static final String ALLOW = "Allow";

        private Fields() {
        }
    }
}

