/*
 * Decompiled with CFR 0.152.
 */
package de.hanbei.httpserver.common;

import java.net.URI;

public class Content {
    private static final String UTF8_ENCODING = "utf-8";
    private String encoding;
    private String mimetype;
    private String charset = "utf-8";
    private int length = -1;
    private byte[] content;
    private URI location;
    private String language;
    private String md5;
    private String range;
    private boolean string;

    public String getComposedContentType() {
        if (this.mimetype != null) {
            if (this.charset == null) {
                return this.mimetype;
            }
            return this.mimetype + "; charset=" + this.charset;
        }
        return null;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.mimetype = this.getType(mimetype);
        this.charset = this.getCharset(mimetype);
    }

    private String getType(String mimetype) {
        return mimetype.split(";")[0];
    }

    private String getCharset(String mimetype) {
        String[] charset = mimetype.split(";");
        if (charset.length > 1) {
            return charset[1].split("=")[1];
        }
        return UTF8_ENCODING;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public byte[] getContent() {
        if (this.length < 0) {
            return new byte[0];
        }
        byte[] result = new byte[this.content.length];
        System.arraycopy(this.content, 0, result, 0, this.content.length);
        return result;
    }

    public void setContent(byte[] content) {
        this.content = new byte[content.length];
        System.arraycopy(content, 0, this.content, 0, content.length);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public URI getLocation() {
        return this.location;
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.content != null) {
            if (this.encoding != null) {
                builder.append("Content-Encoding");
                builder.append(": ");
                builder.append(this.encoding);
                builder.append("\n");
            }
            if (this.mimetype != null) {
                builder.append("Content-Type");
                builder.append(": ");
                builder.append(this.mimetype);
                if (this.charset != null) {
                    builder.append("; charset=");
                    builder.append(this.charset);
                }
                builder.append("\n");
            }
            if (this.length > 0) {
                builder.append("Content-Length");
                builder.append(": ");
                builder.append(this.length);
                builder.append("\n");
            }
            if (this.language != null) {
                builder.append("Content-Language");
                builder.append(": ");
                builder.append(this.language);
                builder.append("\n");
            }
            if (this.md5 != null) {
                builder.append("Content-MD5");
                builder.append(": ");
                builder.append(this.md5);
                builder.append("\n");
            }
            if (this.range != null) {
                builder.append("Content-Range");
                builder.append(": ");
                builder.append(this.range);
                builder.append("\n");
            }
            builder.append("\n");
            builder.append(new String(this.content));
        }
        builder.append("\n");
        return builder.toString();
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public String getRange() {
        return this.range;
    }

    public String getContentAsString() {
        if (this.content != null) {
            return new String(this.content);
        }
        return "";
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setString(boolean string) {
        this.string = string;
    }

    public boolean isString() {
        return this.string;
    }
}

