/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.common.hash;

import de.greenrobot.common.PrimitiveArrayUtils;
import java.util.zip.Checksum;

public class FNVJ64
implements Checksum {
    private static PrimitiveArrayUtils primitiveArrayUtils = PrimitiveArrayUtils.getInstance();
    private static final long INITIAL_VALUE = -3750763034362895579L;
    private static final long MULTIPLIER = 1099511628211L;
    private static final int[] PARTIAL_SHIFTS = new int[]{56, 48, 40, 32, 24, 16, 8, 0};
    private final long seed;
    private long hash;
    private int partialPos;
    private int length;

    public FNVJ64() {
        this.seed = -3750763034362895579L;
        this.hash = -3750763034362895579L;
    }

    public FNVJ64(long seed) {
        this.hash = this.seed = 0xCBF29CE484222325L ^ seed;
    }

    @Override
    public void update(int b) {
        if (this.partialPos == 0) {
            this.hash *= 1099511628211L;
        }
        long xorValue = 0xFF & b;
        if (this.partialPos != 7) {
            xorValue <<= PARTIAL_SHIFTS[this.partialPos];
        }
        this.hash ^= xorValue;
        ++this.partialPos;
        if (this.partialPos == 8) {
            this.partialPos = 0;
        }
        ++this.length;
    }

    @Override
    public void update(byte[] b, int off, int len) {
        int i;
        while (this.partialPos != 0 && len > 0) {
            this.update(b[off]);
            ++off;
            --len;
        }
        int remainder = len & 7;
        int stop = off + len - remainder;
        for (i = off; i < stop; i += 8) {
            this.hash *= 1099511628211L;
            this.hash ^= primitiveArrayUtils.getLongBE(b, i);
        }
        this.length += stop - off;
        for (i = 0; i < remainder; ++i) {
            this.update(b[stop + i]);
        }
    }

    @Override
    public long getValue() {
        long finished = this.hash * 1099511628211L;
        finished ^= (long)this.length;
        return finished *= 1099511628211L;
    }

    @Override
    public void reset() {
        this.hash = this.seed;
        this.partialPos = 0;
        this.length = 0;
    }

    public int getLength() {
        return this.length;
    }
}

