/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.common;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectCache<KEY, T> {
    private final Map<KEY, Reference<T>> cache;
    private final boolean useWeakReferences;

    public static <KEY, T> ObjectCache<KEY, T> createUsingWeakReferences() {
        return new ObjectCache<KEY, T>(true);
    }

    public static <KEY, T> ObjectCache<KEY, T> createUsingSoftReferences() {
        return new ObjectCache<KEY, T>(false);
    }

    private ObjectCache(boolean useWeakReferences) {
        this.useWeakReferences = useWeakReferences;
        this.cache = new ConcurrentHashMap<KEY, Reference<T>>();
    }

    public T put(KEY key, T object) {
        Reference ref = this.useWeakReferences ? new WeakReference<T>(object) : new SoftReference<T>(object);
        Reference oldRef = this.cache.put(key, ref);
        if (oldRef != null) {
            return oldRef.get();
        }
        return null;
    }

    public void putAll(Map<KEY, T> mapDataToPut) {
        Set<Map.Entry<KEY, T>> entries = mapDataToPut.entrySet();
        for (Map.Entry<KEY, T> entry : entries) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public T get(KEY key) {
        Reference<T> ref = this.cache.get(key);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public void clear() {
        this.cache.clear();
    }

    public T remove(KEY key) {
        Reference<T> oldRef = this.cache.remove(key);
        if (oldRef != null) {
            return oldRef.get();
        }
        return null;
    }

    public void cleanUp() {
        Set<KEY> keySet = this.cache.keySet();
        for (KEY key : keySet) {
            Reference<T> ref = this.cache.get(key);
            if (ref == null || ref.get() != null) continue;
            this.cache.remove(key);
        }
    }

    public boolean isValueExpired(KEY key) {
        Reference<T> ref = this.cache.get(key);
        if (ref != null) {
            return ref.get() == null;
        }
        return false;
    }

    public boolean containsKey(KEY key) {
        return this.cache.containsKey(key);
    }

    public boolean containsKeyWithValue(KEY key) {
        return this.get(key) != null;
    }

    public Set<KEY> keySet() {
        return this.cache.keySet();
    }

    public int size() {
        return this.cache.size();
    }
}

