/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.utils;

import de.fraunhofer.iosb.ilt.frostclient.Version;
import de.fraunhofer.iosb.ilt.frostclient.models.DataModel;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServerInfo {
    private URL baseUrl;
    private String mqttUrl;
    private String mqttBasePath = "";
    private Version version;
    private boolean mqttExpandAllowed = false;
    private boolean mqttFilterAllowed = false;
    private final List<DataModel> models = new ArrayList<DataModel>();

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isBaseUrlSet() {
        return this.baseUrl != null;
    }

    public ServerInfo setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public String getMqttUrl() {
        return this.mqttUrl;
    }

    public boolean isMqttUrlSet() {
        return this.mqttUrl != null;
    }

    public ServerInfo setMqttUrl(String mqttUrl) {
        this.mqttUrl = mqttUrl;
        return this;
    }

    public String getMqttBasePath() {
        return this.mqttBasePath;
    }

    public ServerInfo setMqttBasePath(String mqttBasePath) {
        this.mqttBasePath = mqttBasePath;
        return this;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public List<DataModel> getModels() {
        return this.models;
    }

    public ServerInfo addModel(DataModel modelToAdd) {
        this.models.add(modelToAdd);
        if (StringHelper.isNullOrEmpty(this.mqttBasePath)) {
            this.mqttBasePath = modelToAdd.getMqttBasePath();
        }
        return this;
    }

    public ServerInfo addModels(Collection<DataModel> modelsToAdd) {
        for (DataModel model : modelsToAdd) {
            this.addModel(model);
        }
        return this;
    }

    public boolean isMqttExpandAllowed() {
        return this.mqttExpandAllowed;
    }

    public void setMqttExpandAllowed(boolean mqttExpandAllowed) {
        this.mqttExpandAllowed = mqttExpandAllowed;
    }

    public boolean isMqttFilterAllowed() {
        return this.mqttFilterAllowed;
    }

    public void setMqttFilterAllowed(boolean mqttFilterAllowed) {
        this.mqttFilterAllowed = mqttFilterAllowed;
    }
}

