/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.utils;

import de.fraunhofer.iosb.ilt.settings.ConfigProvider;
import de.fraunhofer.iosb.ilt.settings.Settings;
import de.fraunhofer.iosb.ilt.settings.annotation.DefaultValueInt;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ChangingStatusLogger
extends ConfigProvider<ChangingStatusLogger> {
    @DefaultValueInt(value=1000)
    public static final String TAG_CNF_LOG_INTERVAL_MS = "logInterval";
    private long logIntervalMs = 1000L;
    private final Logger logger;
    private final List<ChangingStatus> logStatuses = new CopyOnWriteArrayList<ChangingStatus>();
    private ScheduledExecutorService executor;
    private final Runnable task;
    private boolean running = false;

    public ChangingStatusLogger(Settings settings, Logger logger) {
        super(settings);
        this.logger = logger;
        this.task = this::maybeLog;
        this.logIntervalMs = this.getInt(TAG_CNF_LOG_INTERVAL_MS);
    }

    public ChangingStatusLogger addLogStatus(ChangingStatus logStatus) {
        this.logStatuses.add(logStatus);
        return this;
    }

    public ChangingStatusLogger removeLogStatus(ChangingStatus logStatus) {
        this.logStatuses.remove(logStatus);
        logStatus.logIfChanged(this.logger);
        return this;
    }

    public ChangingStatusLogger setLogIntervalMs(long logIntervalMs) {
        this.logIntervalMs = logIntervalMs;
        return this;
    }

    public ChangingStatusLogger start() {
        if (this.running) {
            return this;
        }
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
        }
        this.running = true;
        this.executor.scheduleAtFixedRate(this.task, this.logIntervalMs, this.logIntervalMs, TimeUnit.MILLISECONDS);
        return this;
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        this.running = false;
        this.maybeLog();
    }

    private void maybeLog() {
        for (ChangingStatus status : this.logStatuses) {
            status.logIfChanged(this.logger);
        }
    }

    public ChangingStatusLogger getThis() {
        return this;
    }

    public static interface ChangingStatus {
        public String getLogMessageTemplate();

        public Object[] getCurrentParams();

        public Object[] getCopyCurrentParams();

        public void logIfChanged(Logger var1);

        default public void process() {
        }
    }

    public static class ChangingStatusDefault
    implements ChangingStatus {
        private final String logMessageTemplate;
        private final Object[] status;
        private Object[] previous;

        public ChangingStatusDefault(String logMessageTemplate, Object[] status) {
            this.logMessageTemplate = logMessageTemplate;
            this.status = status;
        }

        public ChangingStatusDefault(String logMessageTemplate, int paramCount) {
            this.logMessageTemplate = logMessageTemplate;
            this.status = new Object[paramCount];
        }

        public final void setAllTo(Object value) {
            for (int idx = 0; idx < this.status.length; ++idx) {
                this.status[idx] = value;
            }
        }

        public final void setObjectAt(int idx, Object value) {
            this.status[idx] = value;
        }

        @Override
        public String getLogMessageTemplate() {
            return this.logMessageTemplate;
        }

        @Override
        public final Object[] getCurrentParams() {
            return this.status;
        }

        @Override
        public Object[] getCopyCurrentParams() {
            return Arrays.copyOf(this.status, this.status.length);
        }

        @Override
        public void logIfChanged(Logger logger) {
            try {
                this.process();
                Object[] currentStatus = this.getCopyCurrentParams();
                if (!Arrays.deepEquals(currentStatus, this.previous)) {
                    this.previous = currentStatus;
                    logger.info(this.logMessageTemplate, this.previous);
                }
            }
            catch (RuntimeException ex) {
                logger.warn("Exception checking changes: {}", (Object)ex.getMessage());
                logger.debug("Exception:", (Throwable)ex);
            }
        }
    }
}

