/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.utils;

import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.dao.Dao;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.utils.CollectionsHelper;
import de.fraunhofer.iosb.ilt.frostclient.utils.EntityCacheDynamic;
import de.fraunhofer.iosb.ilt.frostclient.utils.PropertyExtractor;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import java.util.HashMap;
import java.util.Map;

public class CacheCollection {
    private final SensorThingsService service;
    private final Map<String, EntityCacheDynamic<String>> caches = new HashMap<String, EntityCacheDynamic<String>>();
    private String defaultLocalIdKey = "localId";

    public CacheCollection(SensorThingsService service) {
        this.service = service;
    }

    public CacheCollection setDefaultLocalIdKey(String defaultLocalIdKey) {
        this.defaultLocalIdKey = defaultLocalIdKey;
        return this;
    }

    public CacheCollection createCache(EntityType et, PropertyExtractor<String, Entity> localIdExtractor, PropertyExtractor<String, String> filterFromlocalId) {
        EntityCacheDynamic<String> ec = new EntityCacheDynamic<String>(this.service.dao(et)).setLocalIdExtractor(localIdExtractor).setFilterFromlocalId(filterFromlocalId);
        this.caches.put(et.getEntityName(), ec);
        return this;
    }

    public CacheCollection createLocalIdCache(EntityType et) {
        if (this.caches.containsKey(et.getEntityName())) {
            throw new IllegalStateException("CacheCollection already contains a cache for " + et.getEntityName());
        }
        PropertyExtractor<String, Entity> localIdExtractor = CacheCollection.createLocalIdExtractor(et, this.defaultLocalIdKey);
        PropertyExtractor<String, String> filterFromLocalId = this.createFilterFromLocalId();
        EntityCacheDynamic<String> ec = new EntityCacheDynamic<String>(this.service.dao(et)).setLocalIdExtractor(localIdExtractor).setFilterFromlocalId(filterFromLocalId);
        this.caches.put(et.getEntityName(), ec);
        return this;
    }

    public CacheCollection createNameCache(EntityType et) {
        if (this.caches.containsKey(et.getEntityName())) {
            throw new IllegalStateException("CacheCollection already contains a cache for " + et.getEntityName());
        }
        EntityCacheDynamic<String> ec = CacheCollection.createNameCache(et, this.service.dao(et));
        this.caches.put(et.getEntityName(), ec);
        return this;
    }

    public static EntityCacheDynamic<String> createNameCache(EntityType et, Dao dao) {
        PropertyExtractor<String, Entity> nameExtractor = CacheCollection.createNameExtractor(et);
        PropertyExtractor<String, String> filterFromName = PropertyExtractor.createFilterFromName();
        EntityCacheDynamic<String> ec = new EntityCacheDynamic<String>(dao).setLocalIdExtractor(nameExtractor).setFilterFromlocalId(filterFromName);
        return ec;
    }

    public static PropertyExtractor<String, Entity> createLocalIdExtractor(EntityType et, String localIdKey) {
        Property propProperties = et.getProperty("properties");
        if (propProperties == null) {
            throw new IllegalArgumentException("Entity Type has no properties: can't create a localIdExtractor!");
        }
        PropertyExtractor<String, Entity> localIdExtractor = entity -> String.valueOf(CollectionsHelper.getFrom(entity.getProperty(propProperties), localIdKey));
        return localIdExtractor;
    }

    public static PropertyExtractor<String, Entity> createNameExtractor(EntityType et) {
        Property propName = et.getProperty("name");
        if (propName == null) {
            throw new IllegalArgumentException("EntityType " + String.valueOf(et) + " has no property 'name'");
        }
        PropertyExtractor<String, Entity> nameExtractor = entity -> (String)entity.getProperty(propName);
        return nameExtractor;
    }

    public PropertyExtractor<String, String> createFilterFromLocalId() {
        return localId -> "properties/" + this.defaultLocalIdKey + " eq " + StringHelper.quoteForUrl(localId);
    }

    public EntityCacheDynamic<String> getCache(EntityType et) {
        return this.caches.get(et.getEntityName());
    }

    public EntityCacheDynamic<String> getCacheNameBased(EntityType et) {
        EntityCacheDynamic<String> cache = this.caches.get(et.getEntityName());
        if (cache == null) {
            return this.createNameCache(et).getCache(et);
        }
        return cache;
    }

    public void clear() {
        for (EntityCacheDynamic<String> cache : this.caches.values()) {
            cache.clear();
        }
    }
}

