/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple;

import com.fasterxml.jackson.databind.JsonNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.constraint.AllowedValues;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple.AbstractRange;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantityRange
extends AbstractRange<QuantityRange, BigDecimal> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuantityRange.class);
    private String uom;
    private List<BigDecimal> value;
    private AllowedValues constraint;

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.uom);
        hash = 67 * hash + Objects.hashCode(this.value);
        hash = 67 * hash + Objects.hashCode(this.constraint);
        hash = 67 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuantityRange other = (QuantityRange)obj;
        if (!Objects.equals(this.uom, other.uom)) {
            return false;
        }
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.constraint, other.constraint)) {
            return false;
        }
        return super.equals(obj);
    }

    public String getUom() {
        return this.uom;
    }

    public QuantityRange setUom(String uom) {
        this.uom = uom;
        return this;
    }

    @Override
    public List<BigDecimal> getValue() {
        return this.value;
    }

    @Override
    public QuantityRange setValue(List<BigDecimal> value) {
        this.value = value;
        return this;
    }

    public AllowedValues getConstraint() {
        return this.constraint;
    }

    public QuantityRange setConstraint(AllowedValues constraint) {
        this.constraint = constraint;
        return this;
    }

    @Override
    public boolean valueIsValid() {
        return this.validate(this.value);
    }

    @Override
    protected boolean validateArray(JsonNode input) {
        if (this.constraint == null) {
            return true;
        }
        for (JsonNode item : input) {
            if (!item.isNumber()) {
                LOGGER.debug("Non-number value {} for CountRange.", (Object)input);
                return false;
            }
            if (this.constraint.isValid(item.decimalValue())) continue;
            LOGGER.error("Item '{}' does not fit the constraint", (Object)item);
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(List<BigDecimal> input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        int size = input.size();
        if (size != 2) {
            LOGGER.debug("Range must have 2 items, found: {}", (Object)size);
            return false;
        }
        if (this.constraint == null) {
            return true;
        }
        for (BigDecimal item : input) {
            if (this.constraint.isValid(item)) continue;
            LOGGER.error("Item '{}' does not fit the constraint", (Object)item);
            return false;
        }
        return true;
    }

    @Override
    protected QuantityRange self() {
        return this;
    }
}

