/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple;

import com.fasterxml.jackson.databind.JsonNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.constraint.AllowedTokens;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple.AbstractRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryRange
extends AbstractRange<CategoryRange, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryRange.class);
    private List<String> value = new ArrayList<String>();
    private AllowedTokens constraint;
    private Map<String, String> codeSpace;

    public AllowedTokens getConstraint() {
        return this.constraint;
    }

    public CategoryRange setConstraint(AllowedTokens constraint) {
        this.constraint = constraint;
        return this;
    }

    @Override
    public List<String> getValue() {
        return this.value;
    }

    @Override
    public CategoryRange setValue(List<String> value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean valueIsValid() {
        return this.validate(this.value);
    }

    @Override
    protected boolean validateArray(JsonNode input) {
        if (this.constraint == null) {
            return true;
        }
        for (JsonNode item : input) {
            if (!item.isTextual()) {
                LOGGER.debug("Non-text item {} in array", (Object)item);
                return false;
            }
            if (this.constraint.isValid(item.asText())) continue;
            LOGGER.error("Item '{}' does not fit the constraint", (Object)item);
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(List<String> input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        int size = input.size();
        if (size != 2) {
            LOGGER.debug("Range must have 2 items, found: {}", (Object)size);
            return false;
        }
        if (this.constraint == null) {
            return true;
        }
        for (String item : input) {
            if (this.constraint.isValid(item)) continue;
            LOGGER.error("Item '{}' does not fit the constraint", (Object)item);
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.value);
        hash = 59 * hash + Objects.hashCode(this.constraint);
        hash = 59 * hash + Objects.hashCode(this.codeSpace);
        hash = 59 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryRange other = (CategoryRange)obj;
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.constraint, other.constraint)) {
            return false;
        }
        if (!Objects.equals(this.codeSpace, other.codeSpace)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected CategoryRange self() {
        return this;
    }
}

