/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.constraint.AllowedTokens;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple.AbstractSimpleComponent;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Category
extends AbstractSimpleComponent<Category, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Category.class.getName());
    private String value = "";
    private AllowedTokens constraint;
    private Map<String, String> codeSpace;

    public AllowedTokens getConstraint() {
        return this.constraint;
    }

    public Category setConstraint(AllowedTokens constraint) {
        this.constraint = constraint;
        return this;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Category setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean valueIsValid() {
        return this.validate(this.value);
    }

    @Override
    public boolean validate(Object input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (input instanceof String) {
            String s = (String)input;
            return this.validate(s);
        }
        LOGGER.debug("Value is not a String: {}", (Object)this.value);
        return false;
    }

    @Override
    public boolean validate(JsonNode input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (!input.isTextual()) {
            LOGGER.debug("Given value is not textual: {}", (Object)input);
            return false;
        }
        return this.validate(input.asText());
    }

    public boolean validate(String input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (this.constraint == null) {
            return true;
        }
        return this.constraint.isValid(input);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.value);
        hash = 17 * hash + Objects.hashCode(this.constraint);
        hash = 17 * hash + Objects.hashCode(this.codeSpace);
        hash = 17 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Category other = (Category)obj;
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.constraint, other.constraint)) {
            return false;
        }
        if (!Objects.equals(this.codeSpace, other.codeSpace)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected Category self() {
        return this;
    }

    @Override
    public ObjectNode asJsonSchema() {
        ObjectNode schema = super.asJsonSchema().put("type", "string");
        if (this.constraint != null) {
            this.constraint.addToSchema(schema);
        }
        return schema;
    }
}

