/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple;

import com.fasterxml.jackson.databind.JsonNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.simple.AbstractSimpleComponent;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRange<T extends AbstractSimpleComponent<T, List<V>>, V>
extends AbstractSimpleComponent<T, List<V>> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractRange.class.getName());

    @Override
    public final boolean validate(Object input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (input instanceof JsonNode) {
            JsonNode j = (JsonNode)input;
            return this.validate(j);
        }
        if (input instanceof List) {
            List list = (List)input;
            return this.validate(list);
        }
        if (input instanceof Object[]) {
            Object[] arr = (Object[])input;
            return this.validate(Arrays.asList(arr));
        }
        LOGGER.debug("Input not a list/array: {}", input);
        return false;
    }

    @Override
    public final boolean validate(JsonNode input) {
        if (input == null) {
            return this.isOptional() || this.isSecret();
        }
        if (input.isArray()) {
            return this.validateArray(input);
        }
        LOGGER.debug("Input not a list/array: {}", (Object)input);
        return false;
    }

    protected abstract boolean validateArray(JsonNode var1);

    public abstract boolean validate(List<V> var1);
}

