/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.swecommon.complex;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.fraunhofer.iosb.ilt.frostclient.models.swecommon.AbstractDataComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRecord
extends AbstractDataComponent<DataRecord, Map<String, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DataRecord.class.getName());
    private List<AbstractDataComponent> fields;

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.fields);
        hash = 29 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataRecord other = (DataRecord)obj;
        if (!Objects.equals(this.fields, other.fields)) {
            return false;
        }
        return super.equals(obj);
    }

    public List<AbstractDataComponent> getFields() {
        if (this.fields == null) {
            this.fields = new ArrayList<AbstractDataComponent>();
        }
        return this.fields;
    }

    public DataRecord setField(List<AbstractDataComponent> fields) {
        return this.setFields(fields);
    }

    public DataRecord setFields(List<AbstractDataComponent> fields) {
        this.fields = fields;
        return this;
    }

    public Optional<AbstractDataComponent> getFieldByName(String name) {
        return this.getFields().stream().filter(f -> f.getName().equals(name)).findFirst();
    }

    public DataRecord addDataComponent(String name, AbstractDataComponent field) {
        if (!name.equals(field.getName())) {
            field.setName(name);
        }
        return this.addDataComponent(field);
    }

    public DataRecord addDataComponent(AbstractDataComponent field) {
        String name = field.getName();
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Field must have a non-empty name");
        }
        if (this.getFieldByName(name).isPresent()) {
            throw new IllegalArgumentException("Field with name " + name + " is already present");
        }
        this.getFields().add(field);
        return this;
    }

    @Override
    public Map<String, Object> getValue() {
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        for (AbstractDataComponent f : this.fields) {
            value.put(f.getName(), f.getValue());
        }
        return value;
    }

    @Override
    public DataRecord setValue(Map<String, Object> value) {
        if (this.fields == null) {
            return this;
        }
        for (AbstractDataComponent f : this.fields) {
            Object fieldValue = value.get(f.getName());
            if (fieldValue == null) continue;
            f.setValue(fieldValue);
        }
        return this;
    }

    @Override
    public boolean valueIsValid() {
        if (this.fields == null) {
            return true;
        }
        for (AbstractDataComponent f : this.fields) {
            if (f.valueIsValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(Object input) {
        if (input instanceof Map) {
            Map mapValue = (Map)input;
            return this.validate(mapValue);
        }
        if (input instanceof List) {
            List list = (List)input;
            return this.validate(list);
        }
        if (input instanceof JsonNode) {
            JsonNode jsonValue = (JsonNode)input;
            return this.validate(jsonValue);
        }
        LOGGER.debug("Value is not a Map or JsonNode: {}", input);
        return false;
    }

    @Override
    public boolean validate(JsonNode input) {
        if (!input.isObject() && !input.isArray()) {
            LOGGER.debug("Value is not an Array or Object: {}", (Object)input);
            return false;
        }
        if (this.fields == null) {
            return true;
        }
        if (input.isObject()) {
            return this.validateObject(input);
        }
        return this.validateArray(input);
    }

    public boolean validateObject(JsonNode input) {
        for (AbstractDataComponent field : this.fields) {
            String fieldName = field.getName();
            JsonNode fieldValue = input.get(fieldName);
            if (fieldValue == null) {
                if (field.isOptional() || field.isSecret()) continue;
                LOGGER.debug("No value for non-optional field {}", (Object)fieldName);
                return false;
            }
            if (field.validate(fieldValue)) continue;
            return false;
        }
        return true;
    }

    public boolean validate(Object ... input) {
        return this.validate(Arrays.asList(input));
    }

    public boolean validate(List<Object> input) {
        if (input.size() != this.fields.size()) {
            LOGGER.debug("Length of value list {} differs from fields array {}", (Object)input.size(), (Object)this.fields.size());
            return false;
        }
        for (int idx = 0; idx < this.fields.size(); ++idx) {
            Object fieldValue;
            AbstractDataComponent field = this.fields.get(idx);
            if (field.validate(fieldValue = input.get(idx))) continue;
            return false;
        }
        return true;
    }

    public boolean validateArray(JsonNode input) {
        if (input.size() != this.fields.size()) {
            LOGGER.debug("Length of value array {} differs from fields array {}", (Object)input.size(), (Object)this.fields.size());
            return false;
        }
        for (int idx = 0; idx < this.fields.size(); ++idx) {
            JsonNode fieldValue;
            AbstractDataComponent field = this.fields.get(idx);
            if (field.validate(fieldValue = input.get(idx))) continue;
            return false;
        }
        return true;
    }

    public boolean validate(Map<String, Object> input) {
        if (this.fields == null) {
            return true;
        }
        for (AbstractDataComponent field : this.fields) {
            String fieldName = field.getName();
            Object fieldValue = input.get(fieldName);
            if (fieldValue == null) {
                if (field.isOptional() || field.isSecret()) continue;
                LOGGER.debug("No value for non-optional field {}", (Object)fieldName);
                return false;
            }
            if (field.validate(fieldValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected DataRecord self() {
        return this;
    }

    @Override
    public ObjectNode asJsonSchema() {
        ObjectNode properties = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode required = new ArrayNode(JsonNodeFactory.instance);
        for (AbstractDataComponent field : this.fields) {
            properties.set(field.getName(), (JsonNode)field.asJsonSchema());
            if (field.isOptional()) continue;
            required.add(field.getName());
        }
        ObjectNode schema = (ObjectNode)super.asJsonSchema().put("type", "object").set("properties", (JsonNode)properties);
        if (!required.isEmpty()) {
            schema.set("required", (JsonNode)required);
        }
        return schema;
    }
}

