/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models.ext;

import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeObject;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Objects;
import net.time4j.Moment;
import net.time4j.SystemClock;
import net.time4j.format.expert.Iso8601Format;

public class TimeInstant
implements TimeObject {
    private final Moment dateTime;

    public TimeInstant(Moment dateTime) {
        this.dateTime = dateTime;
    }

    public static TimeInstant now() {
        return new TimeInstant(SystemClock.currentMoment());
    }

    public static TimeInstant create(Moment moment) {
        if (moment == null) {
            return null;
        }
        return new TimeInstant(moment);
    }

    public static TimeInstant create(Instant instant) {
        if (instant == null) {
            return null;
        }
        return new TimeInstant(Moment.from((Instant)instant));
    }

    public static TimeInstant create(ZonedDateTime zdt) {
        if (zdt == null) {
            return null;
        }
        return new TimeInstant(Moment.from((Instant)zdt.toInstant()));
    }

    public int hashCode() {
        return Objects.hash(this.dateTime);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInstant other = (TimeInstant)obj;
        if (this.dateTime == null && other.dateTime == null) {
            return true;
        }
        if (this.dateTime == null || other.dateTime == null) {
            return false;
        }
        return this.dateTime.equals((Object)other.dateTime);
    }

    public static TimeInstant parse(String value) {
        try {
            return new TimeInstant((Moment)Iso8601Format.EXTENDED_DATE_TIME_OFFSET.parse((CharSequence)value));
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Failed to parse TimeInstant " + StringHelper.cleanForLogging(value), ex);
        }
    }

    public Moment getDateTime() {
        return this.dateTime;
    }

    @Override
    public boolean isEmpty() {
        return this.dateTime == null;
    }

    @Override
    public String asISO8601() {
        if (this.dateTime == null) {
            return "";
        }
        return StringHelper.FORMAT_MOMENT.print((Object)this.dateTime);
    }

    public String toString() {
        return this.asISO8601();
    }
}

