/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.models;

import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableClass;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.Version;
import de.fraunhofer.iosb.ilt.frostclient.exception.StatusCodeException;
import de.fraunhofer.iosb.ilt.frostclient.json.SimpleJsonMapper;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostclient.models.DataModel;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import de.fraunhofer.iosb.ilt.frostclient.utils.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigurableClass
public class CSDLModel
implements DataModel,
AnnotatedConfigurable<Object, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CSDLModel.class.getName());
    private static final String DEFAULT_CONTEXT_PATH = "$metadata?$format=json";
    private ModelRegistry mr;
    @ConfigurableField(editor=EditorString.class, optional=true, label="ContextPath", description="The path to the context document, either absolute or relative to the service base url.")
    @EditorString.EdOptsString(dflt="$metadata?$format=json")
    private String contextPath;

    @Override
    public void init(SensorThingsService service, ModelRegistry mr) {
        HttpGet httpGet;
        if (StringHelper.isNullOrEmpty(this.contextPath)) {
            this.contextPath = DEFAULT_CONTEXT_PATH;
        }
        try {
            URL contextUrl = new URL(service.getBaseUrl(), this.contextPath);
            httpGet = new HttpGet(contextUrl.toURI());
            LOGGER.debug("Fetching: {}", (Object)httpGet.getURI());
            httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new IllegalArgumentException("Could not generate context url.", ex);
        }
        try (CloseableHttpResponse response = service.execute((HttpRequestBase)httpGet);){
            Utils.throwIfNotOk((HttpRequestBase)httpGet, response);
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            CsdlDocument csdlDocument = (CsdlDocument)SimpleJsonMapper.getSimpleObjectMapper().readValue(json, CsdlDocument.class);
            csdlDocument.applyTo(mr);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to parse metadata", (Throwable)ex);
        }
        catch (StatusCodeException ex) {
            LOGGER.error("Failed to request metadata", (Throwable)ex);
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public CSDLModel setContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @Override
    public boolean isInitialised() {
        return this.mr != null;
    }

    @Override
    public Version getVersion() {
        return Version.V_ODATA_4_01;
    }
}

