/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.csdl;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.PropertyType;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlItemComplexType;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlItemEntityContainer;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlItemEntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlItemTypeDefinition;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlSchemaItem;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeSimple;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsdlSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CsdlSchema.class.getName());
    private String namespace;
    private String entityContainer;
    private CsdlDocument document;
    @JsonAnyGetter
    public Map<String, CsdlSchemaItem> schemaItems = new LinkedHashMap<String, CsdlSchemaItem>();

    @JsonIgnore
    public String getNamespace() {
        return this.namespace;
    }

    @JsonIgnore
    public String getEntityContainerName() {
        return this.entityContainer;
    }

    @JsonIgnore
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonIgnore
    public Map<String, CsdlSchemaItem> getSchemaItems() {
        return this.schemaItems;
    }

    @JsonAnySetter
    public void addSchemaItem(String name, CsdlSchemaItem schemaItem) {
        schemaItem.setDocument(this.document);
        schemaItem.setSchema(this);
        this.schemaItems.put(name, schemaItem);
    }

    public void setDocument(CsdlDocument document) {
        this.document = document;
    }

    public CsdlSchema fillFrom(CsdlDocument doc, String namespace, String entityContainer, ModelRegistry mr) {
        this.document = doc;
        this.namespace = namespace;
        this.entityContainer = entityContainer;
        for (EntityType entityType : mr.getEntityTypes()) {
            String fullName = entityType.entityName;
            String shortName = this.removeNamespace(fullName);
            this.schemaItems.put(shortName, CsdlItemEntityType.of(doc, namespace, entityType));
        }
        for (Map.Entry entry : mr.getPropertyTypes().entrySet()) {
            String name = this.removeNamespace((String)entry.getKey());
            PropertyType value = (PropertyType)entry.getValue();
            if (value instanceof TypeComplex) {
                TypeComplex tc = (TypeComplex)value;
                this.schemaItems.put(name, CsdlItemComplexType.of(doc, namespace, tc));
                continue;
            }
            if (value instanceof TypeSimple) {
                TypeSimple ts = (TypeSimple)value;
                this.schemaItems.put(name, CsdlItemTypeDefinition.of(doc, namespace, ts));
                continue;
            }
            LOGGER.debug("Unknown PropertyType {}", (Object)value);
        }
        this.schemaItems.put(entityContainer, CsdlItemEntityContainer.of(namespace, mr));
        return this;
    }

    private String removeNamespace(String name) {
        if (name.startsWith(this.namespace)) {
            return name.substring(this.namespace.length() + 1);
        }
        return name;
    }

    public void applyTo(ModelRegistry mr) {
        LinkedHashMap<String, CsdlItemEntityType> entityTypes = new LinkedHashMap<String, CsdlItemEntityType>();
        LinkedHashMap<String, CsdlItemTypeDefinition> typeDefs = new LinkedHashMap<String, CsdlItemTypeDefinition>();
        LinkedHashMap<String, CsdlItemComplexType> complexTypes = new LinkedHashMap<String, CsdlItemComplexType>();
        LinkedHashMap<String, CsdlItemEntityContainer> itemContainers = new LinkedHashMap<String, CsdlItemEntityContainer>();
        for (Map.Entry<String, CsdlSchemaItem> entry : this.schemaItems.entrySet()) {
            String name = entry.getKey();
            CsdlSchemaItem item = entry.getValue();
            if (item instanceof CsdlItemEntityType) {
                CsdlItemEntityType et = (CsdlItemEntityType)item;
                entityTypes.put(name, et);
                continue;
            }
            if (item instanceof CsdlItemTypeDefinition) {
                CsdlItemTypeDefinition td = (CsdlItemTypeDefinition)item;
                typeDefs.put(name, td);
                continue;
            }
            if (item instanceof CsdlItemComplexType) {
                CsdlItemComplexType ct = (CsdlItemComplexType)item;
                complexTypes.put(name, ct);
                continue;
            }
            if (!(item instanceof CsdlItemEntityContainer)) continue;
            CsdlItemEntityContainer ec = (CsdlItemEntityContainer)item;
            itemContainers.put(name, ec);
        }
        String prefix = this.getNamespace() + ".";
        for (Map.Entry entry : typeDefs.entrySet()) {
            ((CsdlItemTypeDefinition)entry.getValue()).applyTo(mr, prefix + (String)entry.getKey());
        }
        for (Map.Entry entry : complexTypes.entrySet()) {
            ((CsdlItemComplexType)entry.getValue()).applyTo(mr, prefix + (String)entry.getKey());
        }
        for (Map.Entry entry : entityTypes.entrySet()) {
            CsdlItemEntityType ciEt = (CsdlItemEntityType)entry.getValue();
            ciEt.setNamespace(this.namespace);
            ciEt.applyTo(mr, prefix + (String)entry.getKey());
        }
        for (Map.Entry entry : entityTypes.entrySet()) {
            ((CsdlItemEntityType)entry.getValue()).applyPropertiesTo(mr, prefix + (String)entry.getKey());
        }
        for (Map.Entry entry : itemContainers.entrySet()) {
            ((CsdlItemEntityContainer)entry.getValue()).applyTo(mr, prefix + (String)entry.getKey());
        }
    }

    public void writeXml(String nameSpace, Writer writer) throws IOException {
        writer.write("<Schema Namespace=\"" + nameSpace + "\" xmlns=\"http://docs.oasis-open.org/odata/ns/edm\">");
        for (Map.Entry<String, CsdlSchemaItem> entry : this.schemaItems.entrySet()) {
            String name = entry.getKey();
            CsdlSchemaItem item = entry.getValue();
            item.writeXml(nameSpace, name, writer);
        }
        writer.write("</Schema>");
    }

    public static CsdlSchema of(CsdlDocument doc, String nameSpace, String entityContainer, ModelRegistry mr) {
        return new CsdlSchema().fillFrom(doc, nameSpace, entityContainer, mr);
    }
}

