/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.csdl;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.PropertyType;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlSchemaItemAbstract;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypePrimitive;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeSimple;
import java.io.IOException;
import java.io.Writer;

public class CsdlItemTypeDefinition
extends CsdlSchemaItemAbstract {
    public static final String NAME_KIND_TYPEDEFINITION = "TypeDefinition";
    @JsonProperty(value="$UnderlyingType")
    public String underlyingType;
    @JsonProperty(value="@Core.Description")
    public String description;

    public CsdlItemTypeDefinition() {
        super(NAME_KIND_TYPEDEFINITION);
    }

    public CsdlItemTypeDefinition fillFrom(TypeSimple tc) {
        this.underlyingType = tc.getUnderlyingType().getName();
        this.description = tc.getDescription();
        return this;
    }

    public void applyTo(ModelRegistry mr, String name) {
        PropertyType ut = mr.getPropertyType(this.underlyingType);
        if (ut == null) {
            throw new IllegalArgumentException("UnderlyingType of TypeDefinition " + name + " not found: " + this.underlyingType);
        }
        if (!(ut instanceof TypePrimitive)) {
            throw new IllegalArgumentException("UnderlyingType of TypeDefinition MUST be a PrimitiveType!");
        }
        TypePrimitive pt = (TypePrimitive)ut;
        mr.registerPropertyType(new TypeSimple(name, this.description, pt));
    }

    @Override
    public void writeXml(String nameSpace, String name, Writer writer) throws IOException {
        writer.write("<TypeDefinition Name=\"" + name + "\" UnderlyingType=\"" + this.underlyingType + "\" />");
    }

    public static CsdlItemTypeDefinition of(CsdlDocument doc, String nameSpace, TypeSimple ts) {
        return new CsdlItemTypeDefinition().fillFrom(ts);
    }
}

