/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.csdl;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlSchemaItemAbstract;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeEnumeration;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;

public class CsdlItemEnumType
extends CsdlSchemaItemAbstract {
    public static final String NAME_KIND_ENUMTYPE = "EnumType";
    @JsonProperty(value="@Core.Description")
    public String description;
    @JsonAnyGetter
    @JsonAnySetter
    public Map<String, Number> values = new LinkedHashMap<String, Number>();

    public CsdlItemEnumType() {
        super(NAME_KIND_ENUMTYPE);
    }

    public CsdlItemEnumType fillFrom(TypeEnumeration<?> te) {
        this.description = te.getDescription();
        for (Map.Entry<String, Number> entry : te.getValues().entrySet()) {
            String name = entry.getKey();
            Number value = entry.getValue();
            this.values.put(name, value);
        }
        return this;
    }

    @Override
    public void writeXml(String nameSpace, String name, Writer writer) throws IOException {
        writer.write("<EnumType Name=\"" + name + "\" UnderlyingType=\"Edm.Int32\">");
        for (Map.Entry<String, Number> entry : this.values.entrySet()) {
            String memberName = entry.getKey();
            Number memberValue = entry.getValue();
            writer.write("<Member Name=\"" + memberName + "\"   Value=\"" + String.valueOf(memberValue) + "\" />");
        }
        writer.write("</EnumType>");
    }
}

