/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.csdl;

import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.annotation.Annotation;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsdlAnnotation {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CsdlAnnotation.class.getName());
    private String name;
    private String namespace;
    private Object value;

    public CsdlAnnotation fillFrom(CsdlDocument doc, Annotation annotation) {
        this.name = annotation.getName();
        this.namespace = annotation.getNameSpace();
        this.value = annotation.getValue();
        doc.registerAnnotation(annotation.getSourceUrl(Annotation.DocType.JSON), this);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getQualifiedName() {
        return this.namespace + "." + this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void writeXml(Writer writer) throws IOException {
        Object object = this.value;
        if (object instanceof Boolean) {
            Boolean boolValue = (Boolean)object;
            if (boolValue.booleanValue()) {
                writer.write("<Annotation Term=\"" + this.getQualifiedName() + "\" />");
            }
            return;
        }
        writer.write("<Annotation Term=\"" + this.getQualifiedName() + "\"");
        object = this.value;
        if (object instanceof String) {
            String string = (String)object;
            writer.write(" String=\"" + StringEscapeUtils.escapeXml11((String)string) + "\" />");
            return;
        }
        LOGGER.error("Unknown annotation value type: {}", (Object)this.value.getClass().getName());
    }

    public static CsdlAnnotation of(CsdlDocument doc, Annotation annotation) {
        return new CsdlAnnotation().fillFrom(doc, annotation);
    }
}

