/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.annotation.Annotatable;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.annotation.Annotation;
import de.fraunhofer.iosb.ilt.frostclient.utils.ParserUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class PropertyType
implements Annotatable {
    private final String name;
    private final String description;
    private JsonDeserializer deserializer;
    private JsonSerializer serializer;
    protected List<Annotation> annotations = new ArrayList<Annotation>();

    protected PropertyType(String name, String description, JsonDeserializer deserializer, JsonSerializer serializer) {
        this.name = name;
        this.description = description;
        this.deserializer = deserializer;
        this.serializer = serializer;
    }

    protected PropertyType(String name, String description, JsonDeserializer deserializer) {
        this(name, description, deserializer, ParserUtils.getDefaultSerializer());
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public JsonDeserializer getDeserializer() {
        return this.deserializer;
    }

    public PropertyType setDeserializer(JsonDeserializer deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public JsonSerializer getSerializer() {
        return this.serializer;
    }

    public PropertyType setSerializer(JsonSerializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public boolean isCollection() {
        return false;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public PropertyType setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    public PropertyType addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }
}

