/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model;

import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.PkSingle;
import de.fraunhofer.iosb.ilt.frostclient.model.PrimaryKey;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.annotation.Annotatable;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.annotation.Annotation;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyAbstract;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypePrimitive;
import de.fraunhofer.iosb.ilt.frostclient.models.CommonProperties;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityType
implements Comparable<EntityType>,
Annotatable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EntityType.class.getName());
    public final String entityName;
    public String namespace = "";
    public String mainSet;
    private boolean initialised = false;
    private PrimaryKey primaryKey;
    private final Set<Property> properties = new LinkedHashSet<Property>();
    private final Map<String, Property> propertiesByName = new LinkedHashMap<String, Property>();
    private final Set<EntityPropertyMain> entityProperties = new LinkedHashSet<EntityPropertyMain>();
    private final Set<NavigationProperty> navigationProperties = new LinkedHashSet<NavigationProperty>();
    private final Set<NavigationPropertyEntity> navigationEntities = new LinkedHashSet<NavigationPropertyEntity>();
    private final Set<NavigationPropertyEntitySet> navigationSets = new LinkedHashSet<NavigationPropertyEntitySet>();
    private ModelRegistry modelRegistry;
    private ToString toStringMethod;
    private List<Annotation> annotations = new ArrayList<Annotation>();

    public EntityType(String singular) {
        this.entityName = singular;
        int nameIdx = singular.lastIndexOf(46);
        if (nameIdx > 0) {
            this.namespace = singular.substring(0, nameIdx);
        }
    }

    public EntityType(String singular, String container) {
        this(singular);
        this.mainSet = container;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setMainContainer(String entityContainer) {
        if (this.mainSet != null) {
            if (this.mainSet.equals(entityContainer)) {
                return;
            }
            throw new IllegalStateException("Main EntityContainer for " + this.entityName + " already set to " + this.mainSet);
        }
        this.mainSet = entityContainer;
    }

    public EntityType setToStringMethod(ToString toStringMethod) {
        this.toStringMethod = toStringMethod;
        return this;
    }

    public EntityType registerProperty(Property property) {
        this.properties.add(property);
        this.propertiesByName.put(property.getName(), property);
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain propertyMain = (EntityPropertyMain)property;
            for (String alias : propertyMain.getAliases()) {
                this.propertiesByName.put(alias, property);
            }
        }
        return this;
    }

    public void init() {
        if (this.initialised) {
            LOGGER.error("Re-Init of EntityType!");
        }
        this.initialised = true;
        for (Property property : this.properties) {
            if (property instanceof EntityPropertyMain) {
                EntityPropertyMain entityPropertyMain = (EntityPropertyMain)property;
                this.entityProperties.add(entityPropertyMain);
            }
            if (!(property instanceof NavigationPropertyAbstract)) continue;
            NavigationPropertyAbstract np = (NavigationPropertyAbstract)property;
            if (np.getInverse() == null) {
                throw new IllegalStateException("NavigationProperty " + np.getName() + " has no inverse.");
            }
            if (np.getInverse().getEntityType() == null) {
                np.getInverse().setEntityType(this);
            }
            this.navigationProperties.add(np);
            if (np instanceof NavigationPropertyEntitySet) {
                NavigationPropertyEntitySet npes = (NavigationPropertyEntitySet)np;
                this.navigationSets.add(npes);
                continue;
            }
            if (!(np instanceof NavigationPropertyEntity)) continue;
            NavigationPropertyEntity npe = (NavigationPropertyEntity)np;
            this.navigationEntities.add(npe);
        }
    }

    public PrimaryKey getPrimaryKey() {
        if (this.primaryKey == null) {
            this.primaryKey = new PkSingle(this.entityProperties.iterator().next());
        }
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
        for (EntityPropertyMain keyProp : primaryKey.getKeyProperties()) {
            keyProp.setKeyPart(true);
        }
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getShortName() {
        if (this.namespace.isEmpty()) {
            return this.entityName;
        }
        return this.entityName.substring(this.namespace.length() + 1);
    }

    public String getMainSetName() {
        return this.mainSet;
    }

    public Property getProperty(String name) {
        return this.propertiesByName.get(name);
    }

    public EntityPropertyMain getEntityProperty(String name) {
        Property property = this.propertiesByName.get(name);
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain entityPropertyMain = (EntityPropertyMain)property;
            return entityPropertyMain;
        }
        return null;
    }

    public NavigationPropertyEntity getNavigationPropertyEntity(String name) {
        Property property = this.propertiesByName.get(name);
        if (property instanceof NavigationPropertyEntity) {
            NavigationPropertyEntity npe = (NavigationPropertyEntity)property;
            return npe;
        }
        return null;
    }

    public NavigationPropertyEntitySet getNavigationPropertySet(String name) {
        Property property = this.propertiesByName.get(name);
        if (property instanceof NavigationPropertyEntitySet) {
            NavigationPropertyEntitySet npes = (NavigationPropertyEntitySet)property;
            return npes;
        }
        return null;
    }

    public NavigationPropertyAbstract getNavigationProperty(String name) {
        Property property = this.propertiesByName.get(name);
        if (property instanceof NavigationPropertyAbstract) {
            NavigationPropertyAbstract npa = (NavigationPropertyAbstract)property;
            return npa;
        }
        return null;
    }

    public Set<Property> getPropertySet() {
        return this.properties;
    }

    public Set<EntityPropertyMain> getEntityProperties() {
        return this.entityProperties;
    }

    public boolean hasProperty(Property property) {
        return this.properties.contains(property);
    }

    public boolean hasProperty(String propertyName) {
        return this.propertiesByName.containsKey(propertyName);
    }

    public Set<NavigationProperty> getNavigationProperties() {
        return this.navigationProperties;
    }

    public Set<NavigationPropertyEntity> getNavigationEntities() {
        return this.navigationEntities;
    }

    public Set<NavigationPropertyEntitySet> getNavigationSets() {
        return this.navigationSets;
    }

    public ModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    public void setModelRegistry(ModelRegistry modelRegistry) {
        if (this.modelRegistry != null && this.modelRegistry != modelRegistry) {
            throw new IllegalArgumentException("Changing the ModelRegistry on an EntityType is not allowed.");
        }
        this.modelRegistry = modelRegistry;
    }

    public String toString() {
        return this.entityName;
    }

    public String display(Entity entity) {
        if (this.toStringMethod == null) {
            this.toStringMethod = ToString.generateDefault(this);
        }
        return this.toStringMethod.toString(entity);
    }

    public String toString(Entity entity) {
        return this.toString() + ": " + String.valueOf(entity.getPrimaryKeyValues()) + " " + this.display(entity);
    }

    @Override
    public int compareTo(EntityType o) {
        return this.entityName.compareTo(o.entityName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityType)) {
            return false;
        }
        EntityType other = (EntityType)obj;
        if (this.entityName.equals(other.entityName)) {
            LOGGER.error("Found other instance of {}", (Object)this.entityName);
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.entityName);
        return hash;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public EntityType setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    public EntityType addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public static interface ToString {
        public String toString(Entity var1);

        public static ToString generateDefault(EntityType et) {
            if (et.hasProperty(CommonProperties.EP_NAME)) {
                return entity -> entity.getProperty(CommonProperties.EP_NAME);
            }
            for (EntityPropertyMain prop : et.getEntityProperties()) {
                if (prop.getType() != TypePrimitive.EDM_STRING) continue;
                EntityPropertyMain strngProp = prop;
                return entity -> (String)entity.getProperty(strngProp);
            }
            return entity -> "";
        }
    }
}

