/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.json.serialize;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.fraunhofer.iosb.ilt.frostclient.json.serialize.EntitySerializer;
import de.fraunhofer.iosb.ilt.frostclient.json.serialize.MomentSerializer;
import de.fraunhofer.iosb.ilt.frostclient.json.serialize.TimeObjectSerializer;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeObject;
import java.io.IOException;
import java.io.Writer;
import net.time4j.Moment;

public class JsonWriter {
    private static ObjectMapper objectMapperInstance;

    public static ObjectMapper getObjectMapper() {
        if (objectMapperInstance == null) {
            JsonWriter.initObjectMapper();
        }
        return objectMapperInstance;
    }

    private static synchronized void initObjectMapper() {
        if (objectMapperInstance == null) {
            objectMapperInstance = JsonWriter.createObjectMapper();
        }
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().serializationInclusion(JsonInclude.Include.NON_EMPTY)).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).disable(new SerializationFeature[]{SerializationFeature.FLUSH_AFTER_WRITE_VALUE})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build();
        SimpleModule module = new SimpleModule();
        module.addSerializer(Entity.class, (JsonSerializer)new EntitySerializer());
        module.addSerializer(TimeObject.class, (JsonSerializer)new TimeObjectSerializer());
        module.addSerializer(Moment.class, (JsonSerializer)new MomentSerializer());
        mapper.registerModule((Module)module);
        return mapper;
    }

    private JsonWriter() {
    }

    public static void writeEntity(Writer writer, Entity entity) throws IOException {
        JsonWriter.getObjectMapper().writeValue(writer, (Object)entity);
    }

    public static String writeEntity(Entity entity) throws JsonProcessingException {
        return JsonWriter.getObjectMapper().writeValueAsString((Object)entity);
    }

    public static byte[] writeBytes(Entity entity) throws JsonProcessingException {
        return JsonWriter.getObjectMapper().writeValueAsBytes((Object)entity);
    }

    public static void writeObject(Writer writer, Object object) throws IOException {
        JsonWriter.getObjectMapper().writeValue(writer, object);
    }

    public static String writeObject(Object object) throws JsonProcessingException {
        return JsonWriter.getObjectMapper().writeValueAsString(object);
    }
}

