/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.json.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostclient.utils.StringHelper;
import java.io.IOException;
import java.text.ParseException;
import net.time4j.Moment;
import net.time4j.format.expert.Iso8601Format;

public class MomentDeserializer
extends StdDeserializer<Moment> {
    public MomentDeserializer() {
        super(TimeInstant.class);
    }

    public Moment deserialize(JsonParser jp, DeserializationContext dc) throws IOException {
        String valueAsString = jp.getValueAsString();
        if (valueAsString == null) {
            return null;
        }
        try {
            return (Moment)Iso8601Format.EXTENDED_DATE_TIME_OFFSET.parse((CharSequence)valueAsString);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Failed to parse TimeInstant " + StringHelper.cleanForLogging(valueAsString), ex);
        }
    }
}

