/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.json.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.EntityDeserializer;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.EntitySetDeserializer;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.MomentDeserializer;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.TimeInstantDeserializer;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.TimeIntervalDeserializer;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.TimeValueDeserializer;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeValue;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.time4j.Moment;

public class JsonReader {
    private static final Map<ModelRegistry, ObjectMapper> mappers = new HashMap<ModelRegistry, ObjectMapper>();
    private final ObjectMapper mapper;
    private final ModelRegistry modelRegistry;

    private static ObjectMapper getObjectMapper(ModelRegistry modelRegistry) {
        return mappers.computeIfAbsent(modelRegistry, mr -> JsonReader.createObjectMapper(mr));
    }

    private static ObjectMapper createObjectMapper(ModelRegistry modelRegistry) {
        ObjectMapper mapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).enable(new DeserializationFeature[]{DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS})).enable(new DeserializationFeature[]{DeserializationFeature.USE_LONG_FOR_INTS})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build();
        SimpleModule module = new SimpleModule();
        for (EntityType entityType : modelRegistry.getEntityTypes()) {
            EntityDeserializer.getInstance(modelRegistry, entityType);
        }
        module.addDeserializer(TimeInstant.class, (JsonDeserializer)new TimeInstantDeserializer());
        module.addDeserializer(TimeInterval.class, (JsonDeserializer)new TimeIntervalDeserializer());
        module.addDeserializer(TimeValue.class, (JsonDeserializer)new TimeValueDeserializer());
        module.addDeserializer(Moment.class, (JsonDeserializer)new MomentDeserializer());
        mapper.registerModule((Module)module);
        return mapper;
    }

    public JsonReader(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
        this.mapper = JsonReader.getObjectMapper(modelRegistry);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public Entity parseEntity(EntityType entityType, byte[] value) throws IOException {
        Entity entity;
        block8: {
            JsonParser parser = this.mapper.createParser(value);
            try {
                entity = this.parseEntity(parser, entityType);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StackOverflowError err) {
                    throw new IOException("Json is too deeply nested.");
                }
            }
            parser.close();
        }
        return entity;
    }

    public Entity parseEntity(EntityType entityType, String value) throws IOException {
        Entity entity;
        block8: {
            JsonParser parser = this.mapper.createParser(value);
            try {
                entity = this.parseEntity(parser, entityType);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StackOverflowError err) {
                    throw new IOException("Json is too deeply nested.");
                }
            }
            parser.close();
        }
        return entity;
    }

    public Entity parseEntity(EntityType entityType, Reader value) throws IOException {
        Entity entity;
        block8: {
            JsonParser parser = this.mapper.createParser(value);
            try {
                entity = this.parseEntity(parser, entityType);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StackOverflowError err) {
                    throw new IOException("Json is too deeply nested.");
                }
            }
            parser.close();
        }
        return entity;
    }

    private Entity parseEntity(JsonParser parser, EntityType entityType) throws IOException {
        DefaultDeserializationContext dsc = (DefaultDeserializationContext)this.mapper.getDeserializationContext();
        dsc = dsc.createInstance(this.mapper.getDeserializationConfig(), parser, this.mapper.getInjectableValues());
        return EntityDeserializer.getInstance(this.modelRegistry, entityType).deserializeFull(parser, (DeserializationContext)dsc);
    }

    public EntitySet parseEntitySet(EntityType entityType, String value) throws IOException {
        EntitySet entitySet;
        block8: {
            JsonParser parser = this.mapper.createParser(value);
            try {
                DefaultDeserializationContext dsc = (DefaultDeserializationContext)this.mapper.getDeserializationContext();
                dsc = dsc.createInstance(this.mapper.getDeserializationConfig(), parser, this.mapper.getInjectableValues());
                entitySet = EntitySetDeserializer.getInstance(this.modelRegistry, entityType).deserializeFull(parser, (DeserializationContext)dsc);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StackOverflowError err) {
                    throw new IOException("Json is too deeply nested.");
                }
            }
            parser.close();
        }
        return entitySet;
    }

    public EntitySet parseEntitySet(EntityType entityType, Reader value) throws IOException {
        EntitySet entitySet;
        block8: {
            JsonParser parser = this.mapper.createParser(value);
            try {
                DefaultDeserializationContext dsc = (DefaultDeserializationContext)this.mapper.getDeserializationContext();
                dsc = dsc.createInstance(this.mapper.getDeserializationConfig(), parser, this.mapper.getInjectableValues());
                entitySet = EntitySetDeserializer.getInstance(this.modelRegistry, entityType).deserializeFull(parser, (DeserializationContext)dsc);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StackOverflowError err) {
                    throw new IOException("Json is too deeply nested.");
                }
            }
            parser.close();
        }
        return entitySet;
    }

    public <T> T parseObject(Class<T> clazz, String value) throws IOException {
        return (T)this.mapper.readValue(value, clazz);
    }

    public <T> T parseObject(Class<T> clazz, Reader value) throws IOException {
        return (T)this.mapper.readValue(value, clazz);
    }

    public <T> T parseObject(TypeReference<T> typeReference, String value) throws IOException {
        return (T)this.mapper.readValue(value, typeReference);
    }

    public <T> T parseObject(TypeReference<T> typeReference, Reader value) throws IOException {
        return (T)this.mapper.readValue(value, typeReference);
    }
}

